/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPlayNetworkHandler {
    @Inject(method={"onChunkData"}, at={@At(value="RETURN")})
    private void litematica_onUpdateChunk(ClientboundLevelChunkWithLightPacket packet, CallbackInfo ci) {
        int chunkX = packet.m_195717_();
        int chunkZ = packet.m_195718_();
        Litematica.debugLog("MixinClientPlayNetworkHandler#litematica_onUpdateChunk({}, {})", chunkX, chunkZ);
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            SchematicWorldRefresher.INSTANCE.markSchematicChunksForRenderUpdate(chunkX, chunkZ);
        }
        DataManager.getSchematicPlacementManager().onClientChunkLoad(chunkX, chunkZ);
    }

    @Inject(method={"onUnloadChunk"}, at={@At(value="RETURN")})
    private void litematica_onChunkUnload(ClientboundForgetLevelChunkPacket packet, CallbackInfo ci) {
        if (!Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue()) {
            Litematica.debugLog("MixinClientPlayNetworkHandler#litematica_onChunkUnload({}, {})", packet.m_132149_(), packet.m_132152_());
            DataManager.getSchematicPlacementManager().onClientChunkUnload(packet.m_132149_(), packet.m_132152_());
        }
    }

    @Inject(method={"onGameMessage"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/message/MessageHandler;onGameMessage(Lnet/minecraft/text/Text;Z)V")})
    private void litematica_onGameMessage(ClientboundSystemChatPacket packet, CallbackInfo ci) {
        if (DataManager.onChatMessage(packet.f_237849_())) {
            ci.cancel();
        }
    }
}

