/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.etherium.items.generic;

import com.aizistral.enigmaticlegacy.api.items.ICreativeTabMember;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import com.aizistral.etherium.core.IEtheriumTool;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ItemEtheriumTool
extends DiggerItem
implements IEtheriumTool,
ICreativeTabMember {
    public Set<TagKey<Block>> effectiveTags = Sets.newHashSet();

    public ItemEtheriumTool(float attackDamageIn, float attackSpeedIn, TagKey<Block> blocks, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, (Tier)EnigmaticMaterials.ETHERIUM, blocks, builder);
    }

    @Override
    public CreativeModeTab getCreativeTab() {
        return EnigmaticTabs.MAIN;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState blockIn) {
        return super.isCorrectToolForDrops(stack, blockIn) || this.hasAnyTag(blockIn, this.effectiveTags);
    }

    protected boolean hasAnyTag(BlockState state, Set<TagKey<Block>> tags) {
        return tags.stream().anyMatch(tag -> this.hasTag(state, (TagKey<Block>)tag));
    }

    protected boolean hasTag(BlockState state, TagKey<Block> tag) {
        return state.m_204336_(tag);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return !this.hasAnyTag(state, this.effectiveTags) ? super.m_8102_(stack, state) : this.f_40980_;
    }
}

