/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.data.recipes;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.data.recipe.RecipeDataUtil;
import com.enderio.core.common.util.JsonUtil;
import com.enderio.core.data.recipes.EnderRecipeProvider;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.init.MachineRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SoulBindingRecipeProvider
extends EnderRecipeProvider {
    public SoulBindingRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        this.build((ItemLike)EIOItems.ENTICING_CRYSTAL, Ingredient.m_204132_((TagKey)Tags.Items.GEMS_EMERALD), 51200, 4, (EntityType<? extends Entity>)EntityType.f_20492_, pFinishedRecipeConsumer);
        this.build((ItemLike)EIOItems.ENDER_CRYSTAL, Ingredient.m_204132_(EIOTags.Items.GEMS_VIBRANT_CRYSTAL), 76800, 6, (EntityType<? extends Entity>)EntityType.f_20566_, pFinishedRecipeConsumer);
        this.build((ItemLike)EIOItems.PRESCIENT_CRYSTAL, Ingredient.m_204132_(EIOTags.Items.GEMS_VIBRANT_CRYSTAL), 100000, 8, (EntityType<? extends Entity>)EntityType.f_20521_, pFinishedRecipeConsumer);
        this.build((ItemLike)EIOItems.FRANK_N_ZOMBIE, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EIOItems.Z_LOGIC_CONTROLLER}), 51200, 4, (EntityType<? extends Entity>)EntityType.f_20501_, pFinishedRecipeConsumer);
        this.build((ItemLike)EIOItems.SENTIENT_ENDER, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EIOItems.ENDER_RESONATOR}), 51200, 4, (EntityType<? extends Entity>)EntityType.f_20495_, pFinishedRecipeConsumer);
        this.build((ItemLike)EIOItems.BROKEN_SPAWNER, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EIOItems.BROKEN_SPAWNER}), 288000, 8, pFinishedRecipeConsumer);
        this.build((ItemLike)MachineBlocks.POWERED_SPAWNER, Ingredient.m_43929_((ItemLike[])new ItemLike[]{MachineBlocks.POWERED_SPAWNER}), 288000, 8, pFinishedRecipeConsumer);
        this.build((ItemLike)MachineBlocks.SOUL_ENGINE, Ingredient.m_43929_((ItemLike[])new ItemLike[]{MachineBlocks.SOUL_ENGINE}), 188000, 5, "engine", pFinishedRecipeConsumer);
        this.build((ItemLike)EIOItems.PLAYER_TOKEN, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EIOItems.DARK_STEEL_BALL}), 12800, 1, (EntityType<? extends Entity>)EntityType.f_20492_, pFinishedRecipeConsumer);
        this.build((ItemLike)EIOItems.MONSTER_TOKEN, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EIOItems.SOULARIUM_BALL}), 12800, 1, MobCategory.MONSTER, pFinishedRecipeConsumer);
        this.build((ItemLike)EIOItems.ANIMAL_TOKEN, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EIOItems.SOULARIUM_BALL}), 12800, 1, MobCategory.CREATURE, pFinishedRecipeConsumer);
    }

    protected void build(ItemLike output, Ingredient input, int energy, int exp, EntityType<? extends Entity> entityType, Consumer<FinishedRecipe> finishedRecipeConsumer) {
        finishedRecipeConsumer.accept(new FinishedSoulBindingRecipe(EnderIO.loc("soulbinding/" + ForgeRegistries.ITEMS.getKey((Object)output.m_5456_()).m_135815_()), output.m_5456_().m_7968_(), input, energy, exp, ForgeRegistries.ENTITY_TYPES.getKey(entityType), null, null));
    }

    protected void build(ItemLike output, Ingredient input, int energy, int exp, MobCategory mobCategory, Consumer<FinishedRecipe> finishedRecipeConsumer) {
        finishedRecipeConsumer.accept(new FinishedSoulBindingRecipe(EnderIO.loc("soulbinding/" + ForgeRegistries.ITEMS.getKey((Object)output.m_5456_()).m_135815_()), output.m_5456_().m_7968_(), input, energy, exp, null, mobCategory, null));
    }

    protected void build(ItemLike output, Ingredient input, int energy, int exp, String souldata, Consumer<FinishedRecipe> finishedRecipeConsumer) {
        finishedRecipeConsumer.accept(new FinishedSoulBindingRecipe(EnderIO.loc("soulbinding/" + ForgeRegistries.ITEMS.getKey((Object)output.m_5456_()).m_135815_()), output.m_5456_().m_7968_(), input, energy, exp, null, null, souldata));
    }

    protected void build(ItemLike output, Ingredient input, int energy, int exp, Consumer<FinishedRecipe> finishedRecipeConsumer) {
        finishedRecipeConsumer.accept(new FinishedSoulBindingRecipe(EnderIO.loc("soulbinding/" + ForgeRegistries.ITEMS.getKey((Object)output.m_5456_()).m_135815_()), output.m_5456_().m_7968_(), input, energy, exp, null, null, null));
    }

    protected static class FinishedSoulBindingRecipe
    extends EnderRecipeProvider.EnderFinishedRecipe {
        private final ItemStack output;
        private final Ingredient input;
        private final int energy;
        private final int exp;
        @Nullable
        private final ResourceLocation entityType;
        @Nullable
        private final MobCategory mobCategory;
        @Nullable
        private final String souldata;

        public FinishedSoulBindingRecipe(ResourceLocation id, ItemStack output, Ingredient input, int energy, int exp, @Nullable ResourceLocation entityType, @Nullable MobCategory mobCategory, @Nullable String souldata) {
            super(id);
            this.output = output;
            this.input = input;
            this.energy = energy;
            this.exp = exp;
            if (entityType != null && mobCategory != null) {
                throw new IllegalStateException("entityType and mobCategory are mutually exclusive!");
            }
            if (souldata != null && mobCategory != null) {
                throw new IllegalStateException("souldata and mobCategory are mutually exclusive!");
            }
            if (entityType != null && souldata != null) {
                throw new IllegalStateException("entityType and souldata are mutually exclusive!");
            }
            this.entityType = entityType;
            this.mobCategory = mobCategory;
            this.souldata = souldata;
        }

        @Override
        public void m_7917_(JsonObject json) {
            json.add("output", (JsonElement)JsonUtil.serializeItemStackWithoutNBT(this.output));
            json.add("input", this.input.m_43942_());
            json.addProperty("energy", (Number)this.energy);
            json.addProperty("exp", (Number)this.exp);
            if (this.entityType != null) {
                json.addProperty("entity_type", this.entityType.toString());
            }
            if (this.mobCategory != null) {
                json.addProperty("mob_category", this.mobCategory.m_21607_());
            }
            if (this.souldata != null) {
                json.addProperty("souldata", this.souldata);
            }
            super.m_7917_(json);
        }

        @Override
        protected Set<String> getModDependencies() {
            HashSet<String> mods = new HashSet<String>(RecipeDataUtil.getIngredientModIds(this.input));
            mods.add(ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135827_());
            return mods;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)MachineRecipes.SOUL_BINDING.serializer().get();
        }
    }
}

