/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.task.host;

import com.enderio.api.UseOnly;
import com.enderio.core.common.blockentity.EnderBlockEntity;
import com.enderio.core.common.network.slot.FloatNetworkDataSlot;
import com.enderio.machines.common.blockentity.task.IMachineTask;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public abstract class MachineTaskHost {
    @Nullable
    private IMachineTask currentTask;
    private boolean isNewTaskAvailable;
    @Nullable
    private CompoundTag pendingTask;
    private boolean hasLoaded;
    @UseOnly(value=LogicalSide.CLIENT)
    private float clientTaskProgress;
    private final Supplier<Level> levelSupplier = () -> ((EnderBlockEntity)blockEntity).m_58904_();
    private final Supplier<Boolean> canAcceptNewTask;
    private static final String KEY_TASK = "Task";

    public MachineTaskHost(EnderBlockEntity blockEntity, Supplier<Boolean> canAcceptNewTask) {
        this.canAcceptNewTask = canAcceptNewTask;
        blockEntity.addDataSlot(new FloatNetworkDataSlot(this::getProgress, p -> {
            this.clientTaskProgress = p.floatValue();
        }));
    }

    @Nullable
    protected Level getLevel() {
        return this.levelSupplier.get();
    }

    @Nullable
    protected abstract IMachineTask getNewTask();

    @Nullable
    protected abstract IMachineTask loadTask(CompoundTag var1);

    @Nullable
    public IMachineTask getCurrentTask() {
        return this.currentTask;
    }

    public final boolean hasTask() {
        return this.currentTask != null && !this.currentTask.isCompleted();
    }

    protected boolean shouldStartNewTask() {
        return this.currentTask == null || this.currentTask.isCompleted();
    }

    public final float getProgress() {
        Level level = this.levelSupplier.get();
        if (level == null) {
            return 0.0f;
        }
        if (level.f_46443_) {
            return this.clientTaskProgress;
        }
        if (!this.hasTask()) {
            return 0.0f;
        }
        return this.currentTask.getProgress();
    }

    public void tick() {
        if (this.isNewTaskAvailable && this.canAcceptNewTask.get().booleanValue() && this.shouldStartNewTask()) {
            this.currentTask = this.getNewTask();
            this.isNewTaskAvailable = false;
        }
        if (this.currentTask != null && !this.currentTask.isCompleted()) {
            this.currentTask.tick();
        }
        if (this.currentTask != null && this.currentTask.isCompleted()) {
            this.newTaskAvailable();
        }
    }

    public final void newTaskAvailable() {
        this.isNewTaskAvailable = true;
    }

    public final void onLevelReady() {
        if (!this.hasLoaded) {
            return;
        }
        if (this.pendingTask != null) {
            this.currentTask = this.loadTask(this.pendingTask);
            this.pendingTask = null;
        }
        if (this.currentTask == null) {
            this.currentTask = this.getNewTask();
        }
    }

    public void save(CompoundTag tag) {
        if (this.hasTask()) {
            tag.m_128365_(KEY_TASK, this.getCurrentTask().serializeNBT());
        }
    }

    public void load(CompoundTag tag) {
        this.hasLoaded = true;
        if (this.levelSupplier.get() == null) {
            if (tag.m_128441_(KEY_TASK)) {
                this.pendingTask = tag.m_128469_(KEY_TASK).m_6426_();
            }
        } else {
            this.currentTask = tag.m_128441_(KEY_TASK) ? this.loadTask(tag.m_128469_(KEY_TASK)) : this.getNewTask();
        }
    }
}

