/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.travel;

import com.enderio.EnderIO;
import com.enderio.api.travel.ITravelTarget;
import com.enderio.api.travel.TravelRegistry;
import com.enderio.base.common.network.AddTravelTargetPacket;
import com.enderio.base.common.network.RemoveTravelTargetPacket;
import com.enderio.base.common.network.SyncTravelDataPacket;
import com.enderio.core.common.network.CoreNetwork;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TravelSavedData
extends SavedData {
    private static final TravelSavedData CLIENT_INSTANCE = new TravelSavedData();
    public static final String TARGETS = "targets";
    private final Map<BlockPos, ITravelTarget> travelTargets = new HashMap<BlockPos, ITravelTarget>();

    public TravelSavedData() {
    }

    public TravelSavedData(CompoundTag nbt) {
        this.loadNBT(nbt);
    }

    public static TravelSavedData getTravelData(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (TravelSavedData)serverLevel.m_8895_().m_164861_(TravelSavedData::new, TravelSavedData::new, "enderio_traveldata");
        }
        return CLIENT_INSTANCE;
    }

    public void loadNBT(CompoundTag nbt) {
        this.travelTargets.clear();
        ListTag targets = nbt.m_128437_(TARGETS, 10);
        targets.stream().map(anchorData -> (CompoundTag)anchorData).map(TravelRegistry::deserialize).flatMap(Optional::stream).forEach(target -> this.travelTargets.put(target.getPos(), (ITravelTarget)target));
    }

    public Optional<ITravelTarget> getTravelTarget(BlockPos pos) {
        return Optional.ofNullable(this.travelTargets.get(pos));
    }

    public Collection<ITravelTarget> getTravelTargets() {
        return this.travelTargets.values();
    }

    public Stream<ITravelTarget> getTravelTargetsInItemRange(BlockPos center) {
        return this.travelTargets.entrySet().stream().filter(entry -> center.m_123331_((Vec3i)entry.getKey()) < (double)(((ITravelTarget)entry.getValue()).getItem2BlockRange() * ((ITravelTarget)entry.getValue()).getItem2BlockRange())).map(Map.Entry::getValue);
    }

    public void addTravelTarget(Level level, ITravelTarget target) {
        if (!level.f_46443_) {
            CoreNetwork.sendToDimension((ResourceKey<Level>)level.m_46472_(), new AddTravelTargetPacket(target));
        }
        if (TravelRegistry.isRegistered(target)) {
            this.travelTargets.put(target.getPos(), target);
        } else {
            EnderIO.LOGGER.warn("Tried to add a not registered TravelTarget to the TravelSavedData with name " + target);
        }
    }

    public void removeTravelTargetAt(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            CoreNetwork.sendToDimension((ResourceKey<Level>)level.m_46472_(), new RemoveTravelTargetPacket(pos));
        }
        this.travelTargets.remove(pos);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag tag = new ListTag();
        tag.addAll(this.travelTargets.values().stream().map(TravelRegistry::serialize).toList());
        nbt.m_128365_(TARGETS, (Tag)tag);
        return nbt;
    }

    public boolean m_77764_() {
        return true;
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CoreNetwork.sendToPlayer(serverPlayer, new SyncTravelDataPacket(TravelSavedData.getTravelData(serverPlayer.m_9236_()).m_7176_(new CompoundTag())));
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CoreNetwork.sendToPlayer(serverPlayer, new SyncTravelDataPacket(TravelSavedData.getTravelData(serverPlayer.m_9236_()).m_7176_(new CompoundTag())));
        }
    }
}

