/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.network;

import com.google.common.collect.Maps;
import fuzs.enchantinginfuser.client.gui.screens.inventory.InfuserScreen;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;

public class S2CCompatibleEnchantsMessage
implements MessageV2<S2CCompatibleEnchantsMessage> {
    private int containerId;
    private Map<Enchantment, Integer> enchantmentsToLevel;

    public S2CCompatibleEnchantsMessage() {
    }

    public S2CCompatibleEnchantsMessage(int containerId, Map<Enchantment, Integer> enchantmentsToLevel) {
        this.containerId = containerId;
        this.enchantmentsToLevel = enchantmentsToLevel;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.containerId);
        buf.writeInt(this.enchantmentsToLevel.size());
        for (Map.Entry<Enchantment, Integer> entry : this.enchantmentsToLevel.entrySet()) {
            buf.writeInt(BuiltInRegistries.f_256876_.m_7447_((Object)entry.getKey()));
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.readByte();
        int size = buf.readInt();
        HashMap enchantmentsToLevel = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            enchantmentsToLevel.put((Enchantment)BuiltInRegistries.f_256876_.m_7942_(buf.readInt()), buf.readInt());
        }
        this.enchantmentsToLevel = enchantmentsToLevel;
    }

    public MessageV2.MessageHandler<S2CCompatibleEnchantsMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CCompatibleEnchantsMessage>(){

            public void handle(S2CCompatibleEnchantsMessage message, Player player, Object gameInstance) {
                AbstractContainerMenu abstractContainerMenu;
                if (player.f_36096_.f_38840_ == message.containerId && (abstractContainerMenu = player.f_36096_) instanceof InfuserMenu) {
                    InfuserMenu menu = (InfuserMenu)abstractContainerMenu;
                    menu.setAndSyncEnchantments(message.enchantmentsToLevel);
                    Screen screen = ((Minecraft)gameInstance).f_91080_;
                    if (screen instanceof InfuserScreen) {
                        InfuserScreen screen2 = (InfuserScreen)screen;
                        screen2.refreshSearchResults();
                    }
                }
            }
        };
    }
}

