/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.brandon3055.draconicevolution.blocks.PlacedItem;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeTransferHelper;
import com.brandon3055.draconicevolution.inventory.ConfigurableItemMenu;
import com.brandon3055.draconicevolution.inventory.FusionCraftingCoreMenu;
import com.brandon3055.draconicevolution.inventory.ModularItemMenu;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import com.brandon3055.draconicevolution.items.tools.Magnet;
import com.brandon3055.draconicevolution.network.InputSync;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;

public class ServerPacketHandler
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayer sender, ServerGamePacketListenerImpl handler) {
        switch (packet.getType()) {
            case 1: {
                this.toggleDislocators((Player)sender);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.moduleSlotClick((Player)sender, (MCDataInput)packet);
                break;
            }
            case 12: {
                this.moduleEntityMessage((Player)sender, (MCDataInput)packet);
                break;
            }
            case 6: {
                this.propertyData(sender, packet);
                break;
            }
            case 7: {
                if (packet.readBoolean()) {
                    ModularItemMenu.tryOpenGui(sender);
                    break;
                }
                ConfigurableItemMenu.tryOpenGui(sender);
                break;
            }
            case 8: {
                ModularItemMenu.tryOpenGui(sender);
                break;
            }
            case 9: {
                this.dislocatorMessage(sender, packet);
                break;
            }
            case 10: {
                this.jeiFusionTransfer(sender, packet);
                break;
            }
            case 11: {
                this.placeItem(sender, packet);
                break;
            }
            case 13: {
                InputSync.setSprintState(sender.m_20148_(), packet.readBoolean());
            }
        }
    }

    private void toggleDislocators(Player player) {
        ArrayList<ItemStack> dislocators = new ArrayList<ItemStack>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof Magnet)) continue;
            dislocators.add(stack);
        }
        for (ItemStack stack : EquipmentManager.getAllItems((LivingEntity)player)) {
            if (!(stack.m_41720_() instanceof Magnet)) continue;
            dislocators.add(stack);
        }
        for (ItemStack stack : dislocators) {
            Magnet.toggleEnabled(stack, player);
            boolean enabled = Magnet.isEnabled(stack);
            player.m_5661_((Component)Component.m_237115_((String)("item_dislocate.draconicevolution." + (enabled ? "activate" : "deactivate"))).m_130940_(enabled ? ChatFormatting.GREEN : ChatFormatting.RED), true);
        }
    }

    private void moduleSlotClick(Player player, MCDataInput input) {
        ModuleHostContainer container;
        ModuleGrid grid;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ModuleHostContainer && (grid = (container = (ModuleHostContainer)abstractContainerMenu).getGrid()) != null) {
            ModuleGrid.GridPos pos = grid.getCell(input.readByte(), input.readByte());
            grid.cellClicked(pos, input.readFloat(), input.readFloat(), input.readByte(), (ClickType)input.readEnum(ClickType.class));
        }
    }

    private void moduleEntityMessage(Player player, MCDataInput input) {
        ModuleGrid.GridPos pos;
        ModuleHostContainer container;
        ModuleGrid grid;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ModuleHostContainer && (grid = (container = (ModuleHostContainer)abstractContainerMenu).getGrid()) != null && (pos = grid.getCell(input.readByte(), input.readByte())).hasEntity()) {
            pos.getEntity().handleClientMessage(input);
        }
    }

    private void propertyData(ServerPlayer sender, PacketCustom packet) {
        PropertyData data = PropertyData.read((MCDataInput)packet);
        ConfigurableItemMenu.handlePropertyData((Player)sender, data);
    }

    private void dislocatorMessage(ServerPlayer sender, PacketCustom packet) {
        ItemStack stack = DislocatorAdvanced.findDislocator((Player)sender);
        if (!stack.m_41619_()) {
            ((DislocatorAdvanced)((Object)DEContent.DISLOCATOR_ADVANCED.get())).handleClientAction(sender, stack, (MCDataInput)packet);
        }
    }

    private void jeiFusionTransfer(ServerPlayer sender, PacketCustom packet) {
        ResourceLocation id = packet.readResourceLocation();
        boolean maxTransfer = packet.readBoolean();
        Recipe recipe = sender.m_9236_().m_7465_().m_44043_(id).orElse(null);
        if (recipe instanceof IFusionRecipe && sender.f_36096_ instanceof FusionCraftingCoreMenu) {
            FusionRecipeTransferHelper.doServerSideTransfer(sender, (FusionCraftingCoreMenu)sender.f_36096_, (IFusionRecipe)recipe, maxTransfer);
        }
    }

    private void placeItem(ServerPlayer player, PacketCustom packet) {
        ItemStack stack = HandHelper.getMainFirst((Player)player);
        if (stack.m_41619_()) {
            return;
        }
        HitResult traceResult = player.m_19907_(5.0, 0.0f, false);
        if (traceResult.m_6662_() == HitResult.Type.BLOCK) {
            Level level = player.m_9236_();
            BlockHitResult blockTrace = (BlockHitResult)traceResult;
            BlockPos posHit = blockTrace.m_82425_();
            if (!com.brandon3055.brandonscore.network.ServerPacketHandler.verifyPlayerPermission((Player)player, (BlockPos)posHit)) {
                return;
            }
            BlockEntity tileHit = level.m_7702_(posHit);
            BlockPos posOnSide = posHit.m_121945_(blockTrace.m_82434_());
            BlockEntity tileOnSide = level.m_7702_(posOnSide);
            if (tileHit instanceof TilePlacedItem && InventoryUtils.insertItem((IItemHandler)((TilePlacedItem)tileHit).itemHandler, (ItemStack)stack, (boolean)true).m_41619_()) {
                InventoryUtils.insertItem((IItemHandler)((TilePlacedItem)tileHit).itemHandler, (ItemStack)stack, (boolean)false);
                player.m_150109_().m_36057_(stack);
            } else if (tileOnSide instanceof TilePlacedItem && InventoryUtils.insertItem((IItemHandler)((TilePlacedItem)tileOnSide).itemHandler, (ItemStack)stack, (boolean)true).m_41619_()) {
                InventoryUtils.insertItem((IItemHandler)((TilePlacedItem)tileOnSide).itemHandler, (ItemStack)stack, (boolean)false);
                player.m_150109_().m_36057_(stack);
            } else if (level.m_46859_(posOnSide) && !ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)posHit), (Direction)blockTrace.m_82434_())) {
                level.m_46597_(posOnSide, (BlockState)((PlacedItem)((Object)DEContent.PLACED_ITEM.get())).m_49966_().m_61124_((Property)PlacedItem.FACING, (Comparable)blockTrace.m_82434_()));
                BlockEntity tile = level.m_7702_(posOnSide);
                if (tile instanceof TilePlacedItem) {
                    ((TilePlacedItem)tile).itemHandler.setStackInSlot(0, stack);
                    player.m_150109_().m_36057_(stack);
                }
            }
        }
    }
}

