/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class DislocatorSaveData
extends SavedData {
    private static final String FILE_NAME = "draconic_dislocator_data";
    private Map<UUID, Map<UUID, DislocatorTarget>> linkTargetMap = new HashMap<UUID, Map<UUID, DislocatorTarget>>();

    @Nullable
    public static DislocatorTarget getLinkTarget(Level world, ItemStack stack) {
        UUID linkID;
        DislocatorSaveData saveData;
        if (BoundDislocator.isValid(stack) && (saveData = DislocatorSaveData.getInstance(world)) != null && saveData.linkTargetMap.containsKey(linkID = BoundDislocator.getLinkId(stack))) {
            Map<UUID, DislocatorTarget> targetMap = saveData.linkTargetMap.get(linkID);
            UUID targetID = BoundDislocator.getDislocatorId(stack);
            for (Map.Entry<UUID, DislocatorTarget> entry : targetMap.entrySet()) {
                UUID entryID = entry.getKey();
                if (entryID.equals(targetID)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static void updateLinkTarget(Level world, ItemStack stack, DislocatorTarget target) {
        DislocatorSaveData saveData;
        if (BoundDislocator.isValid(stack) && (saveData = DislocatorSaveData.getInstance(world)) != null) {
            UUID linkID = BoundDislocator.getLinkId(stack);
            UUID targetID = BoundDislocator.getDislocatorId(stack);
            saveData.linkTargetMap.computeIfAbsent(linkID, uuid -> new HashMap()).put(targetID, target);
            saveData.m_77762_();
        }
    }

    @Nullable
    public static DislocatorSaveData getInstance(Level world) {
        ServerLevel level;
        if (world instanceof ServerLevel && world.m_7654_() != null && (level = world.m_7654_().m_129880_(Level.f_46428_)) != null) {
            return (DislocatorSaveData)level.m_8895_().m_164861_(DislocatorSaveData::load, DislocatorSaveData::new, FILE_NAME);
        }
        return null;
    }

    public static DislocatorSaveData load(CompoundTag nbt) {
        DislocatorSaveData data = new DislocatorSaveData();
        ListTag linkList = nbt.m_128437_("link_map", 10);
        for (Tag lnbt : linkList) {
            CompoundTag linkNBT = (CompoundTag)lnbt;
            UUID linkID = linkNBT.m_128342_("link_id");
            ListTag targetList = linkNBT.m_128437_("targets", 10);
            Map targetMap = data.linkTargetMap.computeIfAbsent(linkID, uuid -> new HashMap());
            for (Tag tnbt : targetList) {
                CompoundTag targetNBT = (CompoundTag)tnbt;
                UUID targetID = targetNBT.m_128342_("target_id");
                DislocatorTarget target = DislocatorTarget.load(targetNBT);
                targetMap.put(targetID, target);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag linkList = new ListTag();
        for (UUID linkID : this.linkTargetMap.keySet()) {
            Map<UUID, DislocatorTarget> targetMap = this.linkTargetMap.get(linkID);
            CompoundTag linkNBT = new CompoundTag();
            linkNBT.m_128362_("link_id", linkID);
            ListTag targetList = new ListTag();
            for (UUID targetID : targetMap.keySet()) {
                DislocatorTarget target = targetMap.get(targetID);
                CompoundTag targetNBT = new CompoundTag();
                targetNBT.m_128362_("target_id", targetID);
                target.save(targetNBT);
                targetList.add((Object)targetNBT);
            }
            linkNBT.m_128365_("targets", (Tag)targetList);
            linkList.add((Object)linkNBT);
        }
        nbt.m_128365_("link_map", (Tag)linkList);
        return nbt;
    }
}

