/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnergyCoreStabilizer
extends EntityBlockBCore {
    public static final BooleanProperty LARGE = BooleanProperty.m_61465_((String)"large");
    public static VoxelShape SHAPE = EnergyCoreStabilizer.m_49796_((double)0.98, (double)0.98, (double)0.98, (double)15.02, (double)15.02, (double)15.02);
    public static VoxelShape SHAPE_X = Shapes.m_83048_((double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)2.0, (double)2.0);
    public static VoxelShape SHAPE_Y = Shapes.m_83048_((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)1.0, (double)2.0);
    public static VoxelShape SHAPE_Z = Shapes.m_83048_((double)-1.0, (double)-1.0, (double)0.0, (double)2.0, (double)2.0, (double)1.0);

    public EnergyCoreStabilizer(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false)));
        this.setBlockEntity(() -> DEContent.TILE_CORE_STABILIZER.get(), true);
        this.dontSpawnOnMe();
        this.setLightTransparent();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LARGE});
    }

    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LARGE) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 10;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEnergyCoreStabilizer && ((TileEnergyCoreStabilizer)tile).isValidMultiBlock.get()) {
            switch ((Direction.Axis)((TileEnergyCoreStabilizer)tile).multiBlockAxis.get()) {
                case X: {
                    return SHAPE_X;
                }
                case Y: {
                    return SHAPE_Y;
                }
                case Z: {
                    return SHAPE_Z;
                }
            }
        }
        return SHAPE;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEnergyCoreStabilizer) {
            ((TileEnergyCoreStabilizer)tile).onPlaced();
        } else {
            super.m_6402_(world, pos, state, placer, stack);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileEnergyCoreStabilizer) {
            TileEnergyCore core;
            if (((TileEnergyCoreStabilizer)tile).isValidMultiBlock.get()) {
                ((TileEnergyCoreStabilizer)tile).revertStructure();
            }
            if ((core = ((TileEnergyCoreStabilizer)tile).getCore()) != null) {
                world.m_46747_(pos);
                ((TileEnergyCoreStabilizer)tile).validateStructure();
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }
}

