/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.apache.logging.log4j.Logger;

public class ServerLevelWrapper
implements IServerLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ConcurrentHashMap<ServerLevel, ServerLevelWrapper> LEVEL_WRAPPER_BY_SERVER_LEVEL = new ConcurrentHashMap();
    private final ServerLevel level;
    @Deprecated
    private IDhLevel parentDhLevel;

    public static ServerLevelWrapper getWrapper(ServerLevel level) {
        return LEVEL_WRAPPER_BY_SERVER_LEVEL.computeIfAbsent(level, ServerLevelWrapper::new);
    }

    public ServerLevelWrapper(ServerLevel level) {
        this.level = level;
    }

    @Override
    public File getMcSaveFolder() {
        return this.level.m_7726_().m_8483_().f_78146_;
    }

    @Override
    public String getWorldFolderName() {
        return ((Path)this.level.m_7654_().m_182649_().get()).getParent().getFileName().toString();
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.m_6042_());
    }

    @Override
    public String getDimensionName() {
        return this.level.m_46472_().m_135782_().toString();
    }

    @Override
    public long getHashedSeed() {
        return this.level.m_7062_().f_47863_;
    }

    @Override
    public String getDhIdentifier() {
        return this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.SERVER_LEVEL;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.m_6042_().f_63856_();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.m_6042_().f_223549_();
    }

    @Override
    public int getMaxHeight() {
        return this.level.m_141928_();
    }

    @Override
    public int getMinHeight() {
        return this.level.m_141937_();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.m_7232_(pos.getX(), pos.getZ())) {
            return null;
        }
        ChunkAccess chunk = this.level.m_6522_(pos.getX(), pos.getZ(), ChunkStatus.f_62326_, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        ServerChunkCache source = this.level.m_7726_();
        return source.m_5563_(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.m_8055_(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.level.m_204166_(McObjectConverter.Convert(pos)), this);
    }

    public ServerLevel getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_BY_SERVER_LEVEL.remove(this.level);
    }

    @Override
    public void setParentLevel(IDhLevel parentLevel) {
        this.parentDhLevel = parentLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getGenericRenderer();
    }

    @Override
    public File getDhSaveFolder() {
        if (this.parentDhLevel == null) {
            return null;
        }
        return this.parentDhLevel.getSaveStructure().getSaveFolder(this);
    }

    public String toString() {
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

