/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc;

import com.google.common.base.Objects;
import com.google.common.collect.MapMaker;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc.IMixinServerPlayer;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.phys.Vec3;

public class ServerPlayerWrapper
implements IServerPlayerWrapper {
    private static final ConcurrentMap<ServerGamePacketListenerImpl, ServerPlayerWrapper> serverPlayerWrapperMap = new MapMaker().weakKeys().weakValues().makeMap();
    private final ServerGamePacketListenerImpl connection;

    public static ServerPlayerWrapper getWrapper(ServerPlayer serverPlayer) {
        return serverPlayerWrapperMap.computeIfAbsent(serverPlayer.f_8906_, ignored -> new ServerPlayerWrapper(serverPlayer.f_8906_));
    }

    private ServerPlayerWrapper(ServerGamePacketListenerImpl connection) {
        this.connection = connection;
    }

    private ServerPlayer getServerPlayer() {
        return this.connection.f_9743_;
    }

    @Override
    public String getName() {
        return this.getServerPlayer().m_7755_().getString();
    }

    @Override
    public IServerLevelWrapper getLevel() {
        ServerLevel level = ((IMixinServerPlayer)this.getServerPlayer()).distantHorizons$getDimensionChangeDestination();
        if (level == null) {
            level = this.getServerPlayer().m_284548_();
        }
        return ServerLevelWrapper.getWrapper(level);
    }

    @Override
    public Vec3d getPosition() {
        Vec3 position = this.getServerPlayer().m_20182_();
        return new Vec3d(position.f_82479_, position.f_82480_, position.f_82481_);
    }

    @Override
    public int getViewDistance() {
        return this.getServerPlayer().f_8924_.m_6846_().m_11312_();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.getServerPlayer().f_8906_.m_264262_();
    }

    @Override
    public Object getWrappedMcObject() {
        return this.getServerPlayer();
    }

    public String toString() {
        return "Wrapped{" + String.valueOf(this.getServerPlayer()) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServerPlayerWrapper)) {
            return false;
        }
        ServerPlayerWrapper that = (ServerPlayerWrapper)obj;
        return Objects.equal((Object)this.connection, (Object)that.connection);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connection});
    }
}

