/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block;

import com.google.common.collect.ImmutableList;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BlockStateWrapper
implements IBlockStateWrapper {
    public static final String RESOURCE_LOCATION_SEPARATOR = ":";
    public static final String STATE_STRING_SEPARATOR = "_STATE_";
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final ConcurrentHashMap<BlockState, BlockStateWrapper> WRAPPER_BY_BLOCK_STATE = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, BlockStateWrapper> WRAPPER_BY_RESOURCE_LOCATION = new ConcurrentHashMap();
    public static final String AIR_STRING = "AIR";
    public static final BlockStateWrapper AIR = new BlockStateWrapper(null, null);
    public static final String DIRT_RESOURCE_LOCATION_STRING = "minecraft:dirt";
    public static HashSet<IBlockStateWrapper> rendererIgnoredBlocks = null;
    public static HashSet<IBlockStateWrapper> rendererIgnoredCaveBlocks = null;
    private static final HashSet<ResourceLocation> BROKEN_RESOURCE_LOCATIONS = new HashSet();
    @Nullable
    public final BlockState blockState;
    private String serialString;
    private final int hashCode;
    private int opacity = -1;
    private byte blockMaterialId = 0;
    private final boolean isBeaconBlock;
    private final boolean isBeaconBaseBlock;
    private final Color beaconTintColor;
    private final Color mapColor;

    public static BlockStateWrapper fromBlockState(BlockState blockState, ILevelWrapper levelWrapper) {
        if (blockState == null || blockState.m_60795_()) {
            return AIR;
        }
        if (WRAPPER_BY_BLOCK_STATE.containsKey(blockState)) {
            return WRAPPER_BY_BLOCK_STATE.get(blockState);
        }
        BlockStateWrapper newWrapper = new BlockStateWrapper(blockState, levelWrapper);
        WRAPPER_BY_BLOCK_STATE.put(blockState, newWrapper);
        return newWrapper;
    }

    public static BlockStateWrapper fromBlockState(BlockState blockState, ILevelWrapper levelWrapper, IBlockStateWrapper guess) {
        BlockState inputBlockState;
        BlockState guessBlockState = guess == null || guess.isAir() ? null : (BlockState)guess.getWrappedMcObject();
        BlockState blockState2 = inputBlockState = blockState == null || blockState.m_60795_() ? null : blockState;
        if (guess instanceof BlockStateWrapper && guessBlockState == inputBlockState) {
            return (BlockStateWrapper)guess;
        }
        return BlockStateWrapper.fromBlockState(blockState, levelWrapper);
    }

    private BlockStateWrapper(BlockState blockState, ILevelWrapper levelWrapper) {
        Block block;
        this.blockState = blockState;
        this.serialString = this.serialize(levelWrapper);
        this.hashCode = Objects.hash(this.serialString);
        this.blockMaterialId = this.calculateEDhApiBlockMaterialId().index;
        String lowercaseSerial = this.serialString.toLowerCase();
        boolean isBeaconBaseBlock = false;
        for (int i = 0; i < LodUtil.BEACON_BASE_BLOCK_NAME_LIST.size(); ++i) {
            String baseBlockName = LodUtil.BEACON_BASE_BLOCK_NAME_LIST.get(i);
            if (!lowercaseSerial.contains(baseBlockName)) continue;
            isBeaconBaseBlock = true;
            break;
        }
        this.isBeaconBaseBlock = isBeaconBaseBlock;
        this.isBeaconBlock = lowercaseSerial.contains("minecraft:beacon");
        Color beaconTintColor = null;
        if (this.blockState != null && !this.isBeaconBlock && (block = this.blockState.m_60734_()) instanceof BeaconBeamBlock) {
            int colorInt = ((BeaconBeamBlock)block).m_7988_().m_284406_().f_283871_;
            beaconTintColor = ColorUtil.toColorObjRGB(colorInt);
        }
        this.beaconTintColor = beaconTintColor;
        int mcColor = 0;
        if (this.blockState != null) {
            mcColor = this.blockState.m_284242_((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)BlockPos.f_121853_).f_283871_;
            this.mapColor = ColorUtil.toColorObjRGB(mcColor);
        } else {
            this.mapColor = new Color(0, 0, 0, 0);
        }
    }

    public static HashSet<IBlockStateWrapper> getRendererIgnoredBlocks(ILevelWrapper levelWrapper) {
        if (rendererIgnoredBlocks != null) {
            return rendererIgnoredBlocks;
        }
        HashSet<String> baseIgnoredBlock = new HashSet<String>();
        baseIgnoredBlock.add(AIR_STRING);
        rendererIgnoredBlocks = BlockStateWrapper.getBlockWrappers(Config.Client.Advanced.Graphics.Culling.ignoredRenderBlockCsv, baseIgnoredBlock, levelWrapper);
        return rendererIgnoredBlocks;
    }

    public static HashSet<IBlockStateWrapper> getRendererIgnoredCaveBlocks(ILevelWrapper levelWrapper) {
        if (rendererIgnoredCaveBlocks != null) {
            return rendererIgnoredCaveBlocks;
        }
        HashSet<String> baseIgnoredBlock = new HashSet<String>();
        baseIgnoredBlock.add(AIR_STRING);
        rendererIgnoredCaveBlocks = BlockStateWrapper.getBlockWrappers(Config.Client.Advanced.Graphics.Culling.ignoredRenderCaveBlockCsv, baseIgnoredBlock, levelWrapper);
        return rendererIgnoredCaveBlocks;
    }

    public static void clearRendererIgnoredBlocks() {
        rendererIgnoredBlocks = null;
    }

    public static void clearRendererIgnoredCaveBlocks() {
        rendererIgnoredCaveBlocks = null;
    }

    private static HashSet<IBlockStateWrapper> getBlockWrappers(ConfigEntry<String> config, HashSet<String> baseResourceLocations, ILevelWrapper levelWrapper) {
        String ignoreBlockCsv;
        HashSet<String> blockStringList = new HashSet<String>();
        if (baseResourceLocations != null) {
            blockStringList.addAll(baseResourceLocations);
        }
        if ((ignoreBlockCsv = config.get()) != null) {
            blockStringList.addAll(Arrays.asList(ignoreBlockCsv.split(",")));
        }
        return BlockStateWrapper.getBlockWrappers(blockStringList, levelWrapper);
    }

    private static HashSet<IBlockStateWrapper> getBlockWrappers(HashSet<String> blockResourceLocationSet, ILevelWrapper levelWrapper) {
        HashSet<IBlockStateWrapper> blockStateWrappers = new HashSet<IBlockStateWrapper>();
        for (String blockResourceLocation : blockResourceLocationSet) {
            try {
                String cleanedResourceLocation;
                if (blockResourceLocation == null || (cleanedResourceLocation = blockResourceLocation.trim()).length() == 0) continue;
                BlockStateWrapper defaultBlockStateToIgnore = (BlockStateWrapper)BlockStateWrapper.deserialize(cleanedResourceLocation, levelWrapper);
                blockStateWrappers.add(defaultBlockStateToIgnore);
                if (defaultBlockStateToIgnore != AIR) {
                    ImmutableList blockStatesToIgnore = defaultBlockStateToIgnore.blockState.m_60734_().m_49965_().m_61056_();
                    for (BlockState blockState : blockStatesToIgnore) {
                        BlockStateWrapper newBlockToIgnore = BlockStateWrapper.fromBlockState(blockState, levelWrapper);
                        blockStateWrappers.add(newBlockToIgnore);
                    }
                    continue;
                }
                blockStateWrappers.add(AIR);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to deserialize block with the resource location: [" + blockResourceLocation + "]. Error: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected error deserializing block with the resource location: [" + blockResourceLocation + "]. Error: " + e.getMessage(), (Throwable)e);
            }
        }
        return blockStateWrappers;
    }

    @Override
    public int getOpacity() {
        if (this.opacity != -1) {
            return this.opacity;
        }
        boolean canOcclude = false;
        boolean propagatesSkyLightDown = true;
        if (this.blockState != null) {
            canOcclude = this.blockState.m_60815_();
            propagatesSkyLightDown = this.blockState.m_60631_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_);
        }
        int opacity = this.isAir() ? 0 : (this.isLiquid() && !canOcclude ? 1 : (propagatesSkyLightDown && !canOcclude ? 0 : 16));
        this.opacity = opacity;
        return this.opacity;
    }

    @Override
    public int getLightEmission() {
        return this.blockState != null ? this.blockState.m_60791_() : 0;
    }

    @Override
    public String getSerialString() {
        return this.serialString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockStateWrapper that = (BlockStateWrapper)obj;
        return Objects.equals(this.getSerialString(), that.getSerialString());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Object getWrappedMcObject() {
        return this.blockState;
    }

    @Override
    public boolean isAir() {
        return this.isAir(this.blockState);
    }

    public boolean isAir(BlockState blockState) {
        return blockState == null || blockState.m_60795_();
    }

    @Override
    public boolean isSolid() {
        if (this.isAir()) {
            return false;
        }
        return !this.blockState.m_60812_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_).m_83281_();
    }

    @Override
    public boolean isLiquid() {
        if (this.isAir()) {
            return false;
        }
        return !this.blockState.m_60819_().m_76178_();
    }

    @Override
    public boolean isBeaconBlock() {
        return this.isBeaconBlock;
    }

    @Override
    public boolean isBeaconBaseBlock() {
        return this.isBeaconBaseBlock;
    }

    @Override
    public boolean isBeaconTintBlock() {
        return this.beaconTintColor != null;
    }

    @Override
    public Color getMapColor() {
        return this.mapColor;
    }

    @Override
    public Color getBeaconTintColor() {
        return this.beaconTintColor;
    }

    @Override
    public byte getMaterialId() {
        return this.blockMaterialId;
    }

    public String toString() {
        return this.getSerialString();
    }

    private String serialize(ILevelWrapper levelWrapper) {
        if (this.blockState == null) {
            return AIR_STRING;
        }
        Level level = (Level)levelWrapper.getWrappedMcObject();
        RegistryAccess registryAccess = level.m_9598_();
        ResourceLocation resourceLocation = registryAccess.m_175515_(Registries.f_256747_).m_7981_((Object)this.blockState.m_60734_());
        if (resourceLocation == null) {
            LOGGER.warn("No ResourceLocation found, unable to serialize: " + String.valueOf(this.blockState));
            return AIR_STRING;
        }
        this.serialString = resourceLocation.m_135827_() + RESOURCE_LOCATION_SEPARATOR + resourceLocation.m_135815_() + STATE_STRING_SEPARATOR + BlockStateWrapper.serializeBlockStateProperties(this.blockState);
        return this.serialString;
    }

    public static IBlockStateWrapper deserialize(String resourceStateString, ILevelWrapper levelWrapper) throws IOException {
        String finalResourceStateString = resourceStateString;
        if (finalResourceStateString.equals(AIR_STRING) || finalResourceStateString.equals("")) {
            return AIR;
        }
        if (WRAPPER_BY_RESOURCE_LOCATION.containsKey(finalResourceStateString)) {
            return WRAPPER_BY_RESOURCE_LOCATION.get(finalResourceStateString);
        }
        BlockStateWrapper foundWrapper = AIR;
        try {
            BlockState foundState;
            Block block;
            ResourceLocation resourceLocation;
            String blockStatePropertiesString;
            block18: {
                int separatorIndex;
                blockStatePropertiesString = null;
                int stateSeparatorIndex = resourceStateString.indexOf(STATE_STRING_SEPARATOR);
                if (stateSeparatorIndex != -1) {
                    blockStatePropertiesString = resourceStateString.substring(stateSeparatorIndex + STATE_STRING_SEPARATOR.length());
                    resourceStateString = resourceStateString.substring(0, stateSeparatorIndex);
                }
                if ((separatorIndex = resourceStateString.indexOf(RESOURCE_LOCATION_SEPARATOR)) == -1) {
                    throw new IOException("Unable to parse Resource Location out of string: [" + resourceStateString + "].");
                }
                try {
                    resourceLocation = new ResourceLocation(resourceStateString.substring(0, separatorIndex), resourceStateString.substring(separatorIndex + 1));
                }
                catch (Exception e) {
                    throw new IOException("No Resource Location found for the string: [" + resourceStateString + "] Error: [" + e.getMessage() + "].");
                }
                try {
                    LodUtil.assertTrue(levelWrapper != null && levelWrapper.getWrappedMcObject() != null);
                    Level level = (Level)levelWrapper.getWrappedMcObject();
                    RegistryAccess registryAccess = level.m_9598_();
                    block = (Block)registryAccess.m_175515_(Registries.f_256747_).m_7745_(resourceLocation);
                    if (block == null) {
                        if (!BROKEN_RESOURCE_LOCATIONS.contains(resourceLocation)) {
                            BROKEN_RESOURCE_LOCATIONS.add(resourceLocation);
                            LOGGER.warn("Unable to find BlockState with the resourceLocation [" + String.valueOf(resourceLocation) + "] and properties: [" + blockStatePropertiesString + "]. Air will be used instead, some data may be lost.");
                        }
                        BlockStateWrapper blockStateWrapper = AIR;
                        return blockStateWrapper;
                    }
                    foundState = null;
                    if (blockStatePropertiesString == null) break block18;
                }
                catch (Exception e) {
                    throw new IOException("Failed to deserialize the string [" + finalResourceStateString + "] into a BlockStateWrapper: " + e.getMessage(), e);
                }
                ImmutableList possibleStateList = block.m_49965_().m_61056_();
                for (BlockState possibleState : possibleStateList) {
                    String possibleStatePropertiesString = BlockStateWrapper.serializeBlockStateProperties(possibleState);
                    if (!possibleStatePropertiesString.equals(blockStatePropertiesString)) continue;
                    foundState = possibleState;
                    break;
                }
            }
            if (foundState == null) {
                if (blockStatePropertiesString != null && !BROKEN_RESOURCE_LOCATIONS.contains(resourceLocation)) {
                    BROKEN_RESOURCE_LOCATIONS.add(resourceLocation);
                    LOGGER.warn("Unable to find BlockState for Block [" + String.valueOf(resourceLocation) + "] with properties: [" + blockStatePropertiesString + "]. Using the default block state.");
                }
                foundState = block.m_49966_();
            }
            BlockStateWrapper blockStateWrapper = foundWrapper = new BlockStateWrapper(foundState, levelWrapper);
            return blockStateWrapper;
        }
        finally {
            WRAPPER_BY_RESOURCE_LOCATION.putIfAbsent(finalResourceStateString, foundWrapper);
        }
    }

    private static String serializeBlockStateProperties(BlockState blockState) {
        Collection blockPropertyCollection = blockState.m_61147_();
        ArrayList sortedBlockPropteryList = new ArrayList(blockPropertyCollection);
        sortedBlockPropteryList.sort((a, b) -> a.m_61708_().compareTo(b.m_61708_()));
        StringBuilder stringBuilder = new StringBuilder();
        for (Property property : sortedBlockPropteryList) {
            String propertyName = property.m_61708_();
            String value = "NULL";
            if (blockState.m_61138_(property)) {
                value = blockState.m_61143_(property).toString();
            }
            stringBuilder.append("{");
            stringBuilder.append(propertyName).append(RESOURCE_LOCATION_SEPARATOR).append(value);
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    private EDhApiBlockMaterial calculateEDhApiBlockMaterialId() {
        if (this.blockState == null) {
            return EDhApiBlockMaterial.AIR;
        }
        String serialString = this.getSerialString().toLowerCase();
        if (this.blockState.m_204336_(BlockTags.f_13035_) || serialString.contains("bamboo") || serialString.contains("cactus") || serialString.contains("chorus_flower") || serialString.contains("mushroom")) {
            return EDhApiBlockMaterial.LEAVES;
        }
        if (this.blockState.m_60713_(Blocks.f_49991_)) {
            return EDhApiBlockMaterial.LAVA;
        }
        if (this.isLiquid() || this.blockState.m_60713_(Blocks.f_49990_)) {
            return EDhApiBlockMaterial.WATER;
        }
        if (this.blockState.m_60827_() == SoundType.f_56736_ || serialString.contains("root") || this.blockState.m_60827_() == SoundType.f_271497_) {
            return EDhApiBlockMaterial.WOOD;
        }
        if (this.blockState.m_60827_() == SoundType.f_56743_ || this.blockState.m_60827_() == SoundType.f_154663_) {
            return EDhApiBlockMaterial.METAL;
        }
        if (serialString.contains("grass_block")) {
            return EDhApiBlockMaterial.GRASS;
        }
        if (serialString.contains("dirt") || serialString.contains("gravel") || serialString.contains("mud") || serialString.contains("podzol") || serialString.contains("mycelium")) {
            return EDhApiBlockMaterial.DIRT;
        }
        if (this.blockState.m_60827_() == SoundType.f_154677_ || this.blockState.m_60827_() == SoundType.f_154678_ || this.blockState.m_60827_() == SoundType.f_154679_ || this.blockState.m_60827_() == SoundType.f_154680_ || serialString.contains("deepslate")) {
            return EDhApiBlockMaterial.DEEPSLATE;
        }
        if (this.serialString.contains("snow")) {
            return EDhApiBlockMaterial.SNOW;
        }
        if (serialString.contains("sand")) {
            return EDhApiBlockMaterial.SAND;
        }
        if (serialString.contains("terracotta")) {
            return EDhApiBlockMaterial.TERRACOTTA;
        }
        if (this.blockState.m_204336_(BlockTags.f_13062_)) {
            return EDhApiBlockMaterial.NETHER_STONE;
        }
        if (serialString.contains("stone") || serialString.contains("ore")) {
            return EDhApiBlockMaterial.STONE;
        }
        if (this.blockState.m_60791_() > 0) {
            return EDhApiBlockMaterial.ILLUMINATED;
        }
        return EDhApiBlockMaterial.UNKNOWN;
    }
}

