/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.GLEnums;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import org.lwjgl.opengl.GL32;

public class GLState {
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private static final int FBO_MAX = 4;
    public int program;
    public int vao;
    public int vbo;
    public int ebo;
    public int[] fbo = new int[4];
    public int texture2D;
    public int activeTextureNumber;
    public int texture0;
    public int texture1;
    public int texture2;
    public int texture3;
    public int frameBufferTexture0;
    public int frameBufferTexture1;
    public int frameBufferDepthTexture;
    public boolean blend;
    public boolean scissor;
    public int blendEqRGB;
    public int blendEqAlpha;
    public int blendSrcColor;
    public int blendSrcAlpha;
    public int blendDstColor;
    public int blendDstAlpha;
    public boolean depth;
    public boolean writeToDepthBuffer;
    public int depthFunc;
    public int[] view;
    public boolean cull;
    public int cullMode;
    public int polyMode;

    public GLState() {
        this.saveState();
    }

    public void saveState() {
        this.program = GL32.glGetInteger((int)35725);
        this.vao = GL32.glGetInteger((int)34229);
        this.vbo = GL32.glGetInteger((int)34964);
        this.ebo = GL32.glGetInteger((int)34965);
        GL32.glGetIntegerv((int)36006, (int[])this.fbo);
        this.texture2D = GL32.glGetInteger((int)32873);
        this.activeTextureNumber = GL32.glGetInteger((int)34016);
        GLMC.glActiveTexture(33984);
        this.texture0 = GL32.glGetInteger((int)32873);
        GLMC.glActiveTexture(33985);
        this.texture1 = GL32.glGetInteger((int)32873);
        GLMC.glActiveTexture(33986);
        this.texture2 = GL32.glGetInteger((int)32873);
        GLMC.glActiveTexture(33987);
        this.texture3 = GL32.glGetInteger((int)32873);
        GLMC.glActiveTexture(this.activeTextureNumber);
        this.frameBufferTexture0 = GL32.glGetFramebufferAttachmentParameteri((int)36160, (int)36064, (int)36049);
        this.frameBufferTexture1 = GL32.glGetFramebufferAttachmentParameteri((int)36160, (int)36065, (int)36049);
        this.frameBufferDepthTexture = GL32.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36049);
        this.blend = GL32.glIsEnabled((int)3042);
        this.scissor = GL32.glIsEnabled((int)3089);
        this.blendEqRGB = GL32.glGetInteger((int)32777);
        this.blendEqAlpha = GL32.glGetInteger((int)34877);
        this.blendSrcColor = GL32.glGetInteger((int)32969);
        this.blendSrcAlpha = GL32.glGetInteger((int)32971);
        this.blendDstColor = GL32.glGetInteger((int)32968);
        this.blendDstAlpha = GL32.glGetInteger((int)32970);
        this.depth = GL32.glIsEnabled((int)2929);
        this.writeToDepthBuffer = GL32.glGetInteger((int)2930) == 1;
        this.depthFunc = GL32.glGetInteger((int)2932);
        this.view = new int[4];
        GL32.glGetIntegerv((int)2978, (int[])this.view);
        this.cull = GL32.glIsEnabled((int)2884);
        this.cullMode = GL32.glGetInteger((int)2885);
        this.polyMode = GL32.glGetInteger((int)2880);
    }

    public String toString() {
        return "GLState{program=" + this.program + ", vao=" + this.vao + ", vbo=" + this.vbo + ", ebo=" + this.ebo + ", fbo=" + this.fbo[0] + ", text=" + GLEnums.getString(this.texture2D) + "@" + this.activeTextureNumber + ", text0=" + GLEnums.getString(this.texture0) + ", FB text0=" + this.frameBufferTexture0 + ", FB text1=" + this.frameBufferTexture1 + ", FB depth=" + this.frameBufferDepthTexture + ", blend=" + this.blend + ", scissor=" + this.scissor + ", blendMode=" + GLEnums.getString(this.blendSrcColor) + "," + GLEnums.getString(this.blendDstColor) + ", depth=" + this.depth + ", view={x:" + this.view[0] + ", y:" + this.view[1] + ", w:" + this.view[2] + ", h:" + this.view[3] + "}, cull=" + this.cull + ", cullMode=" + GLEnums.getString(this.cullMode) + ", polyMode=" + GLEnums.getString(this.polyMode) + '}';
    }

    public void RestoreFrameBuffer() {
        GLMC.glBindFramebuffer(36160, 0);
        for (int i = 0; i < 4; ++i) {
            int buffer = this.fbo[i];
            if (i > 0 && buffer == 0) break;
            GLMC.glBindFramebuffer(36160, GL32.glIsFramebuffer((int)buffer) ? buffer : 0);
        }
    }

    public void restore() {
        this.RestoreFrameBuffer();
        if (this.blend) {
            GLMC.enableBlend();
        } else {
            GLMC.disableBlend();
        }
        if (this.scissor) {
            GLMC.enableScissorTest();
        } else {
            GLMC.disableScissorTest();
        }
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture0) ? this.texture0 : 0);
        GLMC.glActiveTexture(33985);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture1) ? this.texture1 : 0);
        GLMC.glActiveTexture(33986);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture2) ? this.texture2 : 0);
        GLMC.glActiveTexture(33987);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture3) ? this.texture3 : 0);
        GLMC.glActiveTexture(this.activeTextureNumber);
        GLMC.glBindTexture(GL32.glIsTexture((int)this.texture2D) ? this.texture2D : 0);
        GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.frameBufferTexture0, (int)0);
        GL32.glFramebufferTexture2D((int)36160, (int)36065, (int)3553, (int)this.frameBufferTexture1, (int)0);
        GL32.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.frameBufferDepthTexture, (int)0);
        GL32.glBindVertexArray((int)(GL32.glIsVertexArray((int)this.vao) ? this.vao : 0));
        GL32.glBindBuffer((int)34962, (int)(GL32.glIsBuffer((int)this.vbo) ? this.vbo : 0));
        GL32.glBindBuffer((int)34963, (int)(GL32.glIsBuffer((int)this.ebo) ? this.ebo : 0));
        GL32.glUseProgram((int)(GL32.glIsProgram((int)this.program) ? this.program : 0));
        if (this.writeToDepthBuffer) {
            GLMC.enableDepthMask();
        } else {
            GLMC.disableDepthMask();
        }
        GLMC.glBlendFunc(this.blendSrcColor, this.blendDstColor);
        GL32.glBlendEquationSeparate((int)this.blendEqRGB, (int)this.blendEqAlpha);
        GLMC.glBlendFuncSeparate(this.blendSrcColor, this.blendDstColor, this.blendSrcAlpha, this.blendDstAlpha);
        if (this.depth) {
            GLMC.enableDepthTest();
        } else {
            GLMC.disableDepthTest();
        }
        GLMC.glDepthFunc(this.depthFunc);
        GL32.glViewport((int)this.view[0], (int)this.view[1], (int)this.view[2], (int)this.view[3]);
        if (this.cull) {
            GLMC.enableFaceCulling();
        } else {
            GLMC.disableFaceCulling();
        }
        GL32.glCullFace((int)this.cullMode);
        GL32.glPolygonMode((int)1032, (int)this.polyMode);
    }
}

