/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiWorldLoadEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiWorldUnloadEvent;
import com.seibel.distanthorizons.core.Initializer;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SharedApi {
    public static final SharedApi INSTANCE = new SharedApi();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    @Nullable
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    @Nullable
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftSharedWrapper MC_SHARED = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class);
    private static final UpdateChunkPosManager UPDATE_POS_MANAGER = new UpdateChunkPosManager();
    private static final int MAX_UPDATING_CHUNK_COUNT_PER_THREAD_AND_PLAYER = 1000;
    private static final int MIN_MS_BETWEEN_OVERLOADED_LOG_MESSAGE = 30000;
    private static AbstractDhWorld currentWorld;
    private static int lastWorldGenTickDelta;
    private static long lastOverloadedLogMessageMsTime;

    private SharedApi() {
    }

    public static void init() {
        Initializer.init();
    }

    public static EWorldEnvironment getEnvironment() {
        return currentWorld == null ? null : SharedApi.currentWorld.environment;
    }

    public static void setDhWorld(AbstractDhWorld newWorld) {
        currentWorld = newWorld;
        if (currentWorld != null) {
            ThreadPoolUtil.setupThreadPools();
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiWorldLoadEvent.class, new DhApiWorldLoadEvent.EventParam());
        } else {
            ThreadPoolUtil.shutdownThreadPools();
            DebugRenderer.clearRenderables();
            if (MC_RENDER != null) {
                MC_RENDER.clearTargetFrameBuffer();
            }
            AbstractDhRepo.closeAllConnections();
            UPDATE_POS_MANAGER.clear();
            System.gc();
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiWorldUnloadEvent.class, new DhApiWorldUnloadEvent.EventParam());
            DhApiWorldProxy.INSTANCE.setReadOnly(false, false);
        }
    }

    public static void worldGenTick(Runnable worldGenRunnable) {
        if (--lastWorldGenTickDelta <= 0) {
            worldGenRunnable.run();
            lastWorldGenTickDelta = 20;
        }
    }

    public static AbstractDhWorld getAbstractDhWorld() {
        return currentWorld;
    }

    public static DhClientServerWorld getDhClientServerWorld() {
        return currentWorld instanceof DhClientServerWorld ? (DhClientServerWorld)currentWorld : null;
    }

    public static IDhClientWorld getIDhClientWorld() {
        return currentWorld instanceof IDhClientWorld ? (IDhClientWorld)((Object)currentWorld) : null;
    }

    public static IDhServerWorld getIDhServerWorld() {
        return currentWorld instanceof IDhServerWorld ? (IDhServerWorld)((Object)currentWorld) : null;
    }

    public static boolean isChunkAtBlockPosAlreadyUpdating(int blockPosX, int blockPosZ) {
        return UPDATE_POS_MANAGER.contains(new DhChunkPos(new DhBlockPos2D(blockPosX, blockPosZ)));
    }

    public static boolean isChunkAtChunkPosAlreadyUpdating(int chunkPosX, int chunkPosZ) {
        return UPDATE_POS_MANAGER.contains(new DhChunkPos(chunkPosX, chunkPosZ));
    }

    public void clearQueuedChunkUpdates() {
        UPDATE_POS_MANAGER.clear();
    }

    public int getQueuedChunkUpdateCount() {
        return UPDATE_POS_MANAGER.closestQueue.size();
    }

    public void chunkBlockChangedEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, true);
    }

    public void chunkLoadEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, false);
    }

    public void applyChunkUpdate(IChunkWrapper chunkWrapper, ILevelWrapper level, boolean updateNeighborChunks) {
        if (chunkWrapper == null) {
            return;
        }
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        if (DhApiWorldProxy.INSTANCE.getReadOnly()) {
            return;
        }
        IDhLevel dhLevel = dhWorld.getLevel(level);
        if (dhLevel == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        if (dhLevel instanceof DhClientLevel && !((DhClientLevel)dhLevel).shouldProcessChunkUpdate(chunkWrapper.getChunkPos())) {
            return;
        }
        if (UPDATE_POS_MANAGER.contains(chunkWrapper.getChunkPos())) {
            return;
        }
        if (!updateNeighborChunks) {
            SharedApi.queueChunkUpdate(chunkWrapper, null, dhLevel);
        } else {
            SharedApi.queueChunkUpdate(chunkWrapper, SharedApi.getNeighbourChunkListForChunk(chunkWrapper, dhLevel), dhLevel);
        }
    }

    private static ArrayList<IChunkWrapper> getNeighbourChunkListForChunk(IChunkWrapper chunkWrapper, IDhLevel dhLevel) {
        ArrayList<IChunkWrapper> neighbourChunkList = new ArrayList<IChunkWrapper>(9);
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                if (xOffset == 0 && zOffset == 0) {
                    neighbourChunkList.add(chunkWrapper);
                    continue;
                }
                DhChunkPos neighbourPos = new DhChunkPos(chunkWrapper.getChunkPos().getX() + xOffset, chunkWrapper.getChunkPos().getZ() + zOffset);
                IChunkWrapper neighbourChunk = dhLevel.getLevelWrapper().tryGetChunk(neighbourPos);
                if (neighbourChunk == null) continue;
                neighbourChunkList.add(neighbourChunk);
            }
        }
        return neighbourChunkList;
    }

    private static void queueChunkUpdate(IChunkWrapper chunkWrapper, @Nullable ArrayList<IChunkWrapper> neighbourChunkList, IDhLevel dhLevel) {
        SharedApi.queueChunkUpdate(chunkWrapper, neighbourChunkList, dhLevel, false);
    }

    private static void queueChunkUpdate(IChunkWrapper chunkWrapper, @Nullable ArrayList<IChunkWrapper> neighbourChunkList, IDhLevel dhLevel, boolean lightUpdateOnly) {
        PriorityTaskPicker.Executor executor;
        long msBetweenLastLog;
        int remainingCapacity;
        int maxUpdateSizeMultiplier;
        if (MC_CLIENT != null && MC_CLIENT.playerExists()) {
            UPDATE_POS_MANAGER.setCenter(MC_CLIENT.getPlayerChunkPos());
            maxUpdateSizeMultiplier = MC_CLIENT.clientConnectedToDedicatedServer() ? 1 : MC_SHARED.getPlayerCount();
        } else {
            maxUpdateSizeMultiplier = 1 + MC_SHARED.getPlayerCount();
        }
        UPDATE_POS_MANAGER.maxSize = 1000 * Config.Common.MultiThreading.numberOfThreads.get() * maxUpdateSizeMultiplier;
        UpdateChunkData updateData = new UpdateChunkData(chunkWrapper, neighbourChunkList, dhLevel, lightUpdateOnly);
        if (lightUpdateOnly) {
            UPDATE_POS_MANAGER.removeItem(chunkWrapper.getChunkPos());
        }
        if ((remainingCapacity = UPDATE_POS_MANAGER.addItem(chunkWrapper.getChunkPos(), updateData)) <= 0 && (msBetweenLastLog = System.currentTimeMillis() - lastOverloadedLogMessageMsTime) >= 30000L) {
            lastOverloadedLogMessageMsTime = System.currentTimeMillis();
            String message = "\u00a76Distant Horizons overloaded, too many chunks queued for LOD processing. \u00a7r\nThis may result in holes in your LODs. \nFix: move through the world slower, decrease your vanilla render distance, slow down your world pre-generator (IE Chunky), or increase the Distant Horizons' CPU thread counts. \nMax queue count [" + UPDATE_POS_MANAGER.maxSize + "] ([" + 1000 + "] per thread+players).";
            boolean showWarningInChat = Config.Common.Logging.Warning.showUpdateQueueOverloadedChatWarning.get();
            if (showWarningInChat) {
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            EWorldEnvironment environment = SharedApi.getEnvironment();
            if (showWarningInChat || environment == EWorldEnvironment.SERVER_ONLY) {
                LOGGER.warn(message);
            }
        }
        if ((executor = ThreadPoolUtil.getChunkToLodBuilderExecutor()) != null && executor.getQueueSize() < executor.getPoolSize()) {
            try {
                executor.execute(SharedApi::processQueuedChunkUpdate);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueuedChunkUpdate() {
        UpdateChunkData updateData = UPDATE_POS_MANAGER.popClosest();
        if (updateData == null) {
            return;
        }
        IChunkWrapper chunkWrapper = updateData.chunkWrapper;
        @Nullable ArrayList<IChunkWrapper> neighbourChunkList = updateData.neighbourChunkList;
        IDhLevel dhLevel = updateData.dhLevel;
        try {
            ArrayList<IChunkWrapper> nearbyChunkList;
            boolean checkChunkHash = Config.Common.LodBuilding.disableUnchangedChunkCheck.get() == false;
            int oldChunkHash = dhLevel.getChunkHash(chunkWrapper.getChunkPos());
            int newChunkHash = chunkWrapper.getBlockBiomeHashCode();
            if (checkChunkHash && oldChunkHash == newChunkHash && !updateData.lightUpdateOnly) {
                return;
            }
            if (neighbourChunkList != null) {
                nearbyChunkList = neighbourChunkList;
            } else {
                nearbyChunkList = new ArrayList(1);
                nearbyChunkList.add(chunkWrapper);
            }
            if (!updateData.lightUpdateOnly) {
                for (IChunkWrapper adjacentChunk : nearbyChunkList) {
                    IChunkWrapper newCenterChunk = dhLevel.getLevelWrapper().tryGetChunk(adjacentChunk.getChunkPos());
                    if (newCenterChunk == null) continue;
                    SharedApi.queueChunkUpdate(newCenterChunk, SharedApi.getNeighbourChunkListForChunk(newCenterChunk, dhLevel), dhLevel, true);
                }
            }
            DhLightingEngine.INSTANCE.bakeChunkBlockLighting(chunkWrapper, nearbyChunkList, dhLevel.hasSkyLight() ? 15 : 0);
            dhLevel.updateBeaconBeamsForChunk(chunkWrapper, nearbyChunkList);
            dhLevel.updateChunkAsync(chunkWrapper, newChunkHash);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error when updating chunk at pos: [" + chunkWrapper.getChunkPos() + "]", (Throwable)e);
        }
        finally {
            PriorityTaskPicker.Executor executor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
            if (executor != null && !UPDATE_POS_MANAGER.updateDataByChunkPos.isEmpty()) {
                try {
                    executor.execute(SharedApi::processQueuedChunkUpdate);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
    }

    public String getDebugMenuString() {
        String updatingCountStr = F3Screen.NUMBER_FORMAT.format(UPDATE_POS_MANAGER.closestQueue.size());
        String maxUpdateCountStr = F3Screen.NUMBER_FORMAT.format(UPDATE_POS_MANAGER.maxSize);
        return "Queued chunk updates: " + updatingCountStr + " / " + maxUpdateCountStr;
    }

    static {
        lastWorldGenTickDelta = 0;
        lastOverloadedLogMessageMsTime = 0L;
    }

    private static class UpdateChunkPosManager {
        private final PriorityBlockingQueue<DhChunkPos> closestQueue = new PriorityBlockingQueue<DhChunkPos>(500, Comparator.comparingDouble(pos -> pos.squaredDistance(this.center)));
        private final PriorityBlockingQueue<DhChunkPos> furthestQueue = new PriorityBlockingQueue<Object>(500, Comparator.comparingDouble(pos -> ((DhChunkPos)pos).squaredDistance(this.center)).reversed());
        private final ConcurrentHashMap<DhChunkPos, UpdateChunkData> updateDataByChunkPos = new ConcurrentHashMap();
        private DhChunkPos center = new DhChunkPos(0, 0);
        private int maxSize = 500;

        public boolean contains(DhChunkPos pos) {
            return this.updateDataByChunkPos.containsKey(pos);
        }

        public void clear() {
            this.updateDataByChunkPos.clear();
            this.closestQueue.clear();
            this.furthestQueue.clear();
        }

        public void removeItem(DhChunkPos pos) {
            this.updateDataByChunkPos.remove(pos);
            this.closestQueue.remove(pos);
            this.furthestQueue.remove(pos);
        }

        public int addItem(DhChunkPos pos, UpdateChunkData updateData) {
            DhChunkPos furthest;
            int remainingSlots = this.maxSize - this.updateDataByChunkPos.size();
            if (this.updateDataByChunkPos.containsKey(pos)) {
                return remainingSlots;
            }
            if (remainingSlots <= 0 && (furthest = this.furthestQueue.poll()) != null) {
                this.closestQueue.remove(furthest);
                this.updateDataByChunkPos.remove(furthest);
            }
            this.updateDataByChunkPos.put(pos, updateData);
            this.closestQueue.add(pos);
            this.furthestQueue.add(pos);
            return remainingSlots;
        }

        public void setCenter(DhChunkPos newCenter) {
            if (newCenter.equals(this.center)) {
                return;
            }
            this.center = newCenter;
            this.closestQueue.clear();
            this.furthestQueue.clear();
            for (DhChunkPos pos : this.updateDataByChunkPos.keySet()) {
                this.closestQueue.add(pos);
                this.furthestQueue.add(pos);
            }
        }

        public UpdateChunkData popClosest() {
            if (this.closestQueue.isEmpty()) {
                return null;
            }
            DhChunkPos closest = this.closestQueue.poll();
            if (closest == null) {
                return null;
            }
            this.furthestQueue.remove(closest);
            return this.updateDataByChunkPos.remove(closest);
        }
    }

    private static class UpdateChunkData {
        public IChunkWrapper chunkWrapper;
        @Nullable
        public ArrayList<IChunkWrapper> neighbourChunkList;
        public IDhLevel dhLevel;
        public boolean lightUpdateOnly;

        public UpdateChunkData(IChunkWrapper chunkWrapper, @Nullable ArrayList<IChunkWrapper> neighbourChunkList, IDhLevel dhLevel, boolean lightUpdateOnly) {
            this.chunkWrapper = chunkWrapper;
            this.neighbourChunkList = neighbourChunkList;
            this.dhLevel = dhLevel;
            this.lightUpdateOnly = lightUpdateOnly;
        }
    }
}

