/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.category.Server;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;

public class ServerSettingsGui
extends ConfigurationGui<Server> {
    private final Server INSTANCE;
    private final Server DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl serverMessagesButton;
    private TextWidget defaultMOTD;
    private TextWidget defaultName;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;
    private TextWidget pingRateInterval;
    private TextWidget pingRateUnit;

    ServerSettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.server_messages", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        ModuleData defaultData = this.getInstanceData().serverData.get("default");
        String defaultServerMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultName = (TextWidget)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            this.getInstanceData().fallbackServerName = this.defaultName.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_name", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_name", new Object[0])))));
        this.defaultName.setControlMessage(this.getInstanceData().fallbackServerName);
        this.defaultMOTD = (TextWidget)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(1), 180, 20, () -> {
            this.getInstanceData().fallbackServerMotd = this.defaultMOTD.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_motd", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_motd", new Object[0])))));
        this.defaultMOTD.setControlMessage(this.getInstanceData().fallbackServerMotd);
        this.defaultMessage = (TextWidget)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(2), 180, 20, () -> {
            ModuleData defaultServerData = this.getInstanceData().serverData.getOrDefault("default", new ModuleData());
            defaultServerData.setTextOverride(this.defaultMessage.getControlMessage());
            this.getInstanceData().serverData.put("default", defaultServerData);
        }, Constants.TRANSLATOR.translate("gui.config.message.default.server", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")})))));
        this.defaultMessage.setControlMessage(defaultServerMessage);
        this.defaultIcon = (TextWidget)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(3), 147, 20, () -> {
            this.getInstanceData().fallbackServerIcon = this.defaultIcon.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_icon", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_icon", new Object[0])))));
        this.addIconSelector((ExtendedScreen)this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.getInstanceData().fallbackServerIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.getInstanceData().fallbackServerIcon);
        this.serverMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(4), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_messages", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.server", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, true, true, DynamicScrollableList.RenderType.ServerData, (attributeName, currentValue) -> {
            ModuleData defaultServerData = this.getInstanceData().serverData.get("default");
            ModuleData currentServerData = this.getInstanceData().serverData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultServerData, "textOverride") != null ? defaultServerData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentServerData, "textOverride") != null ? currentServerData.getTextOverride() : "";
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty((String)currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.getInstanceData().serverData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().serverData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().serverData.get("default");
            screenInstance.currentData = this.getInstanceData().serverData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.server.edit_specific_server", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            screenInstance.currentData.setTextOverride(inputText);
            this.getInstanceData().serverData.put(attributeName, screenInstance.currentData);
            if (!CraftPresence.SERVER.knownAddresses.contains(attributeName)) {
                CraftPresence.SERVER.knownAddresses.add(attributeName);
            }
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().serverData.remove(attributeName);
            if (!CraftPresence.SERVER.defaultAddresses.contains(attributeName)) {
                CraftPresence.SERVER.knownAddresses.remove(attributeName);
            }
        }, (attributeName, screenInstance) -> {
            if (screenInstance.isPresenceButton) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                screenInstance.currentData.setIconOverride((String)attributeName);
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")})))), (Screen)parentScreen))), () -> {
            if (!this.serverMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.server_messages.server_messages", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")})));
            }
        }, new String[0]));
        this.pingRateInterval = (TextWidget)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(5), 180, 20, () -> {
            this.getInstanceData().pingRateInterval = (Integer)StringUtils.getValidInteger((String)this.pingRateInterval.getControlMessage()).getSecond();
        }, Constants.TRANSLATOR.translate("gui.config.name.server_messages.ping_rate_interval", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.ping_rate_interval", new Object[0])))));
        this.pingRateInterval.setControlMessage(Integer.toString(this.getInstanceData().pingRateInterval));
        this.pingRateUnit = (TextWidget)this.childFrame.addControl((GuiEventListener)new TextWidget(this.getFontRenderer(), this.getButtonY(6), 180, 20, () -> {
            this.getInstanceData().pingRateUnit = this.pingRateUnit.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.server_messages.ping_rate_unit", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.ping_rate_unit", new Object[0])))));
        this.pingRateUnit.setControlMessage(this.getInstanceData().pingRateUnit);
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty((String)this.defaultMessage.getControlMessage()) || !StringUtils.isNullOrEmpty((String)this.defaultName.getControlMessage()) || !StringUtils.isNullOrEmpty((String)this.defaultMOTD.getControlMessage()));
        this.serverMessagesButton.setControlEnabled(CraftPresence.SERVER.isEnabled());
    }

    @Override
    protected Server getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Server getCurrentData() {
        return CraftPresence.CONFIG.serverSettings;
    }

    @Override
    protected Server getDefaultData() {
        return this.DEFAULTS;
    }
}

