/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.AccessibilitySettingsGui;
import com.gitlab.cdagaming.craftpresence.config.gui.AdvancedSettingsGui;
import com.gitlab.cdagaming.craftpresence.config.gui.BiomeSettingsGui;
import com.gitlab.cdagaming.craftpresence.config.gui.DimensionSettingsGui;
import com.gitlab.cdagaming.craftpresence.config.gui.DisplaySettingsGui;
import com.gitlab.cdagaming.craftpresence.config.gui.GeneralSettingsGui;
import com.gitlab.cdagaming.craftpresence.config.gui.ServerSettingsGui;
import com.gitlab.cdagaming.craftpresence.config.gui.StatusMessagesGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.ScrollableTextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;

public class MainGui
extends ConfigurationGui<Config> {
    private final Config INSTANCE;
    private final Config DEFAULTS;
    private ExtendedButtonControl biomeSet;
    private ExtendedButtonControl dimensionSet;
    private ExtendedButtonControl serverSet;

    public MainGui(Screen parentScreen) {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]));
        this.setParent(parentScreen);
        this.DEFAULTS = this.getCurrentData().getDefaults();
        this.INSTANCE = this.getCurrentData().copy();
    }

    public MainGui() {
        this((Screen)null);
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int currentY = -1;
        String releaseNotice = "";
        if ("Release".equalsIgnoreCase("alpha")) {
            releaseNotice = Constants.TRANSLATOR.translate("gui.config.message.tentative", new Object[]{"v2.5.3"});
        } else if (!ModUtils.MCVersion.equalsIgnoreCase("1.20.1")) {
            releaseNotice = Constants.TRANSLATOR.translate("gui.config.message.version_difference", new Object[]{ModUtils.MCVersion, "1.20.1"});
        }
        if (!StringUtils.isNullOrEmpty((String)releaseNotice)) {
            this.childFrame.addWidget((DynamicWidget)new ScrollableTextWidget(true, 0, this.getButtonY(++currentY), this.childFrame.getScreenWidth(), releaseNotice));
        }
        this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc1, this.getButtonY(++currentY), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.general", new Object[0]), () -> this.openScreen(new GeneralSettingsGui()), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.title.general", new Object[0]))), new String[0]));
        this.biomeSet = (ExtendedButtonControl)this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc2, this.getButtonY(currentY), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.biome_messages", new Object[0]), () -> this.openScreen(new BiomeSettingsGui()), () -> {
            if (!this.biomeSet.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})));
            }
        }, new String[0]));
        this.dimensionSet = (ExtendedButtonControl)this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc1, this.getButtonY(++currentY), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.dimension_messages", new Object[0]), () -> this.openScreen(new DimensionSettingsGui()), () -> {
            if (!this.dimensionSet.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("dimension.")})));
            }
        }, new String[0]));
        this.serverSet = (ExtendedButtonControl)this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc2, this.getButtonY(currentY), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.server_messages", new Object[0]), () -> this.openScreen(new ServerSettingsGui()), () -> {
            if (!this.serverSet.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("server.", "world.", "player.")})));
            }
        }, new String[0]));
        this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc1, this.getButtonY(++currentY), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.status_messages", new Object[0]), () -> this.openScreen(new StatusMessagesGui()), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.title.status_messages", new Object[0]))), new String[0]));
        this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc2, this.getButtonY(currentY), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.advanced", new Object[0]), () -> this.openScreen(new AdvancedSettingsGui()), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.title.advanced", new Object[0]))), new String[0]));
        this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc1, this.getButtonY(++currentY), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.accessibility", new Object[0]), () -> this.openScreen(new AccessibilitySettingsGui()), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.title.accessibility", new Object[0]))), new String[0]));
        this.childFrame.addControl((GuiEventListener)new ExtendedButtonControl(calc2, this.getButtonY(currentY), 180, 20, Constants.TRANSLATOR.translate("gui.config.title.display_settings", new Object[0]), () -> this.openScreen(new DisplaySettingsGui()), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.display_settings", new Object[0]))), new String[0]));
    }

    public boolean m_7933_(int keyCode, int mouseX, int mouseY) {
        if (MainGui.isEscapeKey((int)keyCode) && this.getCurrentData().hasChanged()) {
            this.syncData();
        }
        return super.m_7933_(keyCode, mouseX, mouseY);
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.getCurrentData().setChanged(this.hasChangesBetween(this.getCurrentData(), this.getInstanceData()));
        this.biomeSet.setControlEnabled(CraftPresence.BIOMES.isEnabled());
        this.dimensionSet.setControlEnabled(CraftPresence.DIMENSIONS.isEnabled());
        this.serverSet.setControlEnabled(CraftPresence.SERVER.isEnabled());
        this.proceedButton.setControlMessage(Constants.TRANSLATOR.translate(this.getCurrentData().hasChanged() ? "gui.config.message.button.save" : "gui.config.message.button.back", new Object[0]));
    }

    @Override
    protected boolean canReset() {
        return this.allowedToReset() && this.hasChangesBetween(this.getCurrentData(), this.getDefaultData());
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.getDefaultData());
    }

    @Override
    protected void applySettings() {
        if (this.getCurrentData().hasChanged()) {
            this.getCurrentData().save();
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
            this.getCurrentData().applyFrom(this.getInstanceData());
        }
    }

    @Override
    protected Config getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Config getCurrentData() {
        return CraftPresence.CONFIG;
    }

    @Override
    protected Config getDefaultData() {
        this.DEFAULTS.displaySettings.dynamicIcons = this.getCurrentData().displaySettings.dynamicIcons;
        return this.DEFAULTS;
    }

    @Override
    protected Config getSyncData() {
        return Config.loadOrCreate();
    }

    @Override
    protected boolean syncData() {
        Config data = this.getSyncData();
        if (this.setCurrentData(data)) {
            this.getCurrentData().applyFrom(this.getInstanceData());
            return this.setInstanceData(data);
        }
        return false;
    }

    @Override
    protected boolean setData(Config source, Config target) {
        if (this.hasChangesBetween(source, target)) {
            source.transferSettings(target);
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasChangesBetween(Config source, Config target) {
        return target != null && !source.areSettingsEqual(target);
    }
}

