/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MolecularMetamorpherRecipe
implements Recipe<SimpleContainer> {
    private final ImmutableMap<Ingredient, Tuple<Integer, Integer>> ingredients;
    private final ItemStack output;
    private final int cost;
    private final int processTime;
    private final ResourceLocation id;

    public MolecularMetamorpherRecipe(ImmutableMap<Ingredient, Tuple<Integer, Integer>> ingredients, ItemStack output, int cost, int processTime, ResourceLocation id) {
        this.ingredients = ingredients;
        this.output = output;
        this.cost = cost;
        this.processTime = processTime;
        this.id = id;
    }

    public boolean matches(SimpleContainer container, @Nullable Level level) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            contents.add(i, container.m_8020_(i));
        }
        Map<Ingredient, Tuple<Integer, Integer>> ingredientMap = this.getIngredientMapNoFiller();
        ArrayList<Ingredient> ingredientSet = new ArrayList<Ingredient>(ingredientMap.keySet());
        if (!ingredientMap.isEmpty()) {
            block1: for (Map.Entry<Ingredient, Tuple<Integer, Integer>> entry : ingredientMap.entrySet()) {
                Ingredient ingredient = entry.getKey();
                int count = (Integer)entry.getValue().m_14419_();
                for (ItemStack stack : contents) {
                    if (!ingredient.test(stack) || stack.m_41613_() < count) continue;
                    ingredientSet.remove(ingredient);
                    continue block1;
                }
            }
        } else {
            return false;
        }
        return ingredientSet.isEmpty();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.addAll((Collection)this.ingredients.keySet());
        return list;
    }

    public ImmutableMap<Ingredient, Tuple<Integer, Integer>> getIngredientMap() {
        return this.ingredients;
    }

    public Map<Ingredient, Tuple<Integer, Integer>> getIngredientMapNoFiller() {
        HashMap<Ingredient, Tuple<Integer, Integer>> ingredients = new HashMap<Ingredient, Tuple<Integer, Integer>>();
        for (Map.Entry entry : this.getIngredientMap().entrySet()) {
            if (((Ingredient)entry.getKey()).m_43947_() || (Integer)((Tuple)entry.getValue()).m_14419_() <= 0) continue;
            ingredients.put((Ingredient)entry.getKey(), (Tuple<Integer, Integer>)((Tuple)entry.getValue()));
        }
        return ingredients;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(@Nullable RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getCost() {
        return this.cost;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<MolecularMetamorpherRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("experienceobelisk", "molecular_metamorphosis");

        public MolecularMetamorpherRecipe fromJson(ResourceLocation id, JsonObject recipe) {
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipe, (String)"ingredient1"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipe, (String)"ingredient2"));
            Ingredient ingredient3 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipe, (String)"ingredient3"));
            int count1 = GsonHelper.m_13927_((JsonObject)recipe, (String)"count1");
            int count2 = GsonHelper.m_13927_((JsonObject)recipe, (String)"count2");
            int count3 = GsonHelper.m_13927_((JsonObject)recipe, (String)"count3");
            HashMap<Ingredient, Tuple> ingredients = new HashMap<Ingredient, Tuple>();
            ingredients.put(ingredient1, new Tuple((Object)1, (Object)count1));
            ingredients.put(ingredient2, new Tuple((Object)2, (Object)count2));
            ingredients.put(ingredient3, new Tuple((Object)3, (Object)count3));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)recipe, (String)"result"));
            int cost = GsonHelper.m_13927_((JsonObject)recipe, (String)"cost");
            int processTime = GsonHelper.m_13927_((JsonObject)recipe, (String)"processTime");
            return new MolecularMetamorpherRecipe((ImmutableMap<Ingredient, Tuple<Integer, Integer>>)ImmutableMap.copyOf(ingredients), result, cost, processTime, id);
        }

        @Nullable
        public MolecularMetamorpherRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int count1 = buffer.readInt();
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int count2 = buffer.readInt();
            Ingredient ingredient3 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int count3 = buffer.readInt();
            HashMap<Ingredient, Tuple> ingredients = new HashMap<Ingredient, Tuple>();
            ingredients.put(ingredient1, new Tuple((Object)1, (Object)count1));
            ingredients.put(ingredient2, new Tuple((Object)2, (Object)count2));
            ingredients.put(ingredient3, new Tuple((Object)3, (Object)count3));
            ItemStack result = buffer.m_130267_();
            int cost = buffer.readInt();
            int processTime = buffer.readInt();
            return new MolecularMetamorpherRecipe((ImmutableMap<Ingredient, Tuple<Integer, Integer>>)ImmutableMap.copyOf(ingredients), result, cost, processTime, id);
        }

        public void toNetwork(FriendlyByteBuf buffer, MolecularMetamorpherRecipe recipe) {
            Ingredient[] ingredients = new Ingredient[]{Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_};
            int[] counts = new int[]{0, 0, 0};
            for (Map.Entry entry : recipe.getIngredientMap().entrySet()) {
                Ingredient ingredient = (Ingredient)entry.getKey();
                int index = (Integer)((Tuple)entry.getValue()).m_14418_() - 1;
                int count = (Integer)((Tuple)entry.getValue()).m_14419_();
                ingredients[index] = ingredient;
                counts[index] = count;
            }
            for (int i = 0; i < 3; ++i) {
                ingredients[i].m_43923_(buffer);
                buffer.writeInt(counts[i]);
            }
            buffer.writeItemStack(recipe.m_8043_(null), false);
            buffer.writeInt(recipe.cost);
            buffer.writeInt(recipe.processTime);
        }
    }

    public static class Type
    implements RecipeType<MolecularMetamorpherRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "molecular_metamorphosis";
    }
}

