/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities.bibliophage;

import com.cyanogen.experienceobelisk.item.BibliophageItem;
import com.cyanogen.experienceobelisk.registries.RegisterBlocks;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractInfectedBookshelfEntity
extends BlockEntity {
    int timeTillSpawn = -99;
    int spawnDelayMin;
    int spawnDelayMax;
    int orbValue;
    int spawns;
    int decayValue = 0;
    double infectivity = 0.02;
    boolean isDisabled = false;

    public AbstractInfectedBookshelfEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof AbstractInfectedBookshelfEntity) {
            AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)((Object)blockEntity);
            if (!bookshelf.isDisabled) {
                if (bookshelf.decayValue >= bookshelf.spawns) {
                    bookshelf.decay(level, pos);
                } else {
                    if (bookshelf.timeTillSpawn == -99) {
                        bookshelf.resetSpawnDelay();
                    } else if (bookshelf.timeTillSpawn <= 0) {
                        bookshelf.handleExperience(level, pos);
                        bookshelf.incrementDecayValue();
                        bookshelf.resetSpawnDelay();
                    } else {
                        bookshelf.decrementSpawnDelay();
                    }
                    if (level.m_46467_() % 20L == 0L && Math.random() <= bookshelf.infectivity) {
                        bookshelf.infectAdjacent(level, pos);
                    }
                }
            }
        }
    }

    public void infectAdjacent(Level level, BlockPos pos) {
        HashMap<BlockPos, Block> adjacentMap = new HashMap<BlockPos, Block>();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        if (!level.f_46443_) {
            for (BlockPos adjacentPos : this.getAdjacents(pos)) {
                if (!BibliophageItem.getValidBlocksForInfection().contains(level.m_8055_(adjacentPos).m_60734_())) continue;
                Block adjacentBlock = level.m_8055_(adjacentPos).m_60734_();
                adjacentMap.put(adjacentPos, adjacentBlock);
                posList.add(adjacentPos);
            }
        }
        if (!adjacentMap.isEmpty()) {
            int index = (int)Math.floor(Math.random() * (double)posList.size());
            BlockPos posToInfect = (BlockPos)posList.get(index);
            Block block = (Block)adjacentMap.get(posToInfect);
            BibliophageItem.infectBlock(level, posToInfect, block);
        }
    }

    public void resetSpawnDelay() {
        this.timeTillSpawn = (int)((double)this.spawnDelayMin + Math.floor((double)(this.spawnDelayMax - this.spawnDelayMin) * Math.random()));
        this.m_6596_();
    }

    public void decrementSpawnDelay() {
        --this.timeTillSpawn;
        this.m_6596_();
    }

    public void handleExperience(Level level, BlockPos pos) {
        int value = this.orbValue;
        if (!level.f_46443_) {
            ServerLevel server = (ServerLevel)level;
            ExperienceOrb orb = new ExperienceOrb((Level)server, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, value);
            orb.m_20334_(0.0, 0.0, 0.0);
            server.m_7967_((Entity)orb);
        }
    }

    public void incrementDecayValue() {
        ++this.decayValue;
        this.m_6596_();
    }

    public void decay(Level level, BlockPos pos) {
        this.setDisabled(true);
        if (!level.f_46443_) {
            ServerLevel server = (ServerLevel)level;
            ItemStack forgottenDust = new ItemStack((ItemLike)RegisterItems.FORGOTTEN_DUST.get(), 4);
            Block.m_49840_((Level)server, (BlockPos)pos, (ItemStack)forgottenDust);
        }
        level.m_5594_(null, pos, SoundEvents.f_12193_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)((Block)RegisterBlocks.FORGOTTEN_DUST_BLOCK.get()).m_49966_()));
        this.m_7651_();
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public List<BlockPos> getAdjacents(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(pos.m_7494_());
        list.add(pos.m_7495_());
        list.add(pos.m_122012_());
        list.add(pos.m_122019_());
        list.add(pos.m_122029_());
        list.add(pos.m_122024_());
        return list;
    }

    public List<BlockState> getAdjacentBlockStates(Level level, BlockPos pos) {
        ArrayList<BlockState> list = new ArrayList<BlockState>();
        for (BlockPos adjacent : this.getAdjacents(pos)) {
            list.add(level.m_8055_(adjacent));
        }
        return list;
    }

    public int enumerateAdjacentsOfType(Level level, BlockPos pos, BlockState state) {
        int count = 0;
        for (BlockState adjacent : this.getAdjacentBlockStates(level, pos)) {
            if (!adjacent.equals(state)) continue;
            ++count;
        }
        return count;
    }

    public boolean toggleActivity() {
        this.isDisabled = !this.isDisabled;
        this.m_6596_();
        return this.isDisabled;
    }

    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
        this.m_6596_();
    }

    public boolean getDisabled() {
        return this.isDisabled;
    }

    public int getDecayValue() {
        return this.decayValue;
    }

    public int getOrbValue() {
        return this.orbValue;
    }

    public int getSpawns() {
        return this.spawns;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.decayValue = tag.m_128451_("DecayValue");
        this.timeTillSpawn = tag.m_128451_("SpawnDelay");
        this.isDisabled = tag.m_128471_("IsDisabled");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("DecayValue", this.decayValue);
        tag.m_128405_("SpawnDelay", this.timeTillSpawn);
        tag.m_128379_("IsDisabled", this.isDisabled);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("DecayValue", this.decayValue);
        tag.m_128405_("SpawnDelay", this.timeTillSpawn);
        tag.m_128379_("IsDisabled", this.isDisabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

