/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.ContentElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.lib.geometry.Rectangle;
import codechicken.lib.math.MathHelper;
import java.util.Random;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

public class GuiDVD
extends GuiElement<GuiDVD>
implements ContentElement<GuiElement<?>> {
    private static final Random randy = new Random();
    private final GuiElement<?> movingElement;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private Vector2d velocity = null;
    private int bounce = 0;
    private Consumer<Integer> onBounce = bounce -> {};

    public GuiDVD(@NotNull GuiParent<?> parent) {
        super(parent);
        this.movingElement = (GuiElement)((GuiElement)((GuiElement)((GuiElement)new GuiElement(this).constrain(GeoParam.TOP, Constraint.relative(this.get(GeoParam.TOP), () -> this.yOffset))).constrain(GeoParam.LEFT, Constraint.relative(this.get(GeoParam.LEFT), () -> this.xOffset))).constrain(GeoParam.WIDTH, Constraint.match(this.get(GeoParam.WIDTH)))).constrain(GeoParam.HEIGHT, Constraint.match(this.get(GeoParam.HEIGHT)));
    }

    @Override
    public GuiElement<?> getContentElement() {
        return this.movingElement;
    }

    public void start() {
        if (this.velocity == null) {
            this.velocity = new Vector2d(randy.nextBoolean() ? 1.0 : -1.0, randy.nextBoolean() ? 1.0 : -1.0);
            this.velocity.normalize();
        } else {
            this.velocity = null;
            this.yOffset = 0.0;
            this.xOffset = 0.0;
            this.bounce = 0;
        }
    }

    public void onBounce(Consumer<Integer> onBounce) {
        this.onBounce = onBounce;
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
    }

    @Override
    public void render(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        super.render(render, mouseX, mouseY, partialTicks);
        if (this.velocity == null) {
            return;
        }
        double speed = 5.0f * partialTicks;
        this.xOffset += this.velocity.x * speed;
        this.yOffset += this.velocity.y * speed;
        Rectangle rect = this.movingElement.getRectangle();
        int bounces = 0;
        if (this.velocity.y < 0.0 && rect.y() < 0.0 || this.velocity.y > 0.0 && rect.yMax() > (double)this.scaledScreenHeight()) {
            this.velocity.y *= -1.0;
            this.onBounce.accept(this.bounce++);
            ++bounces;
        }
        if (this.velocity.x < 0.0 && rect.x() < 0.0 || this.velocity.x > 0.0 && rect.xMax() > (double)this.scaledScreenWidth()) {
            this.velocity.x *= -1.0;
            this.onBounce.accept(this.bounce++);
            ++bounces;
        }
        if (this.bounce > 0) {
            this.velocity.y += -0.05 + randy.nextGaussian() * 0.1;
            this.velocity.x += -0.05 + randy.nextGaussian() * 0.1;
            this.velocity.x = this.velocity.x > 0.0 ? MathHelper.clip(this.velocity.x, 0.4, 0.6) : MathHelper.clip(this.velocity.x, -0.4, -0.6);
            this.velocity.y = this.velocity.y > 0.0 ? MathHelper.clip(this.velocity.y, 0.4, 0.6) : MathHelper.clip(this.velocity.y, -0.4, -0.6);
            this.velocity.normalize();
        }
    }
}

