/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.item;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.entity.PictureFrameEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class PictureItem
extends Item {
    public static final ResourceLocation ID = Camerapture.id("picture");
    public static final ResourceKey<Item> KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)ID);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("MMM d, yyyy 'at' HH:mm");

    public PictureItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (!user.m_6144_()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_().m_121945_(facing);
        ItemStack itemStack = context.m_43722_();
        if (facing.m_122434_().m_122478_() || !player.m_36204_(pos, facing, itemStack)) {
            return InteractionResult.PASS;
        }
        PictureFrameEntity pictureFrameEntity = new PictureFrameEntity(world, pos, facing);
        if (!pictureFrameEntity.canStayAttached()) {
            return InteractionResult.PASS;
        }
        CompoundTag nbtCompound = itemStack.m_41783_();
        if (nbtCompound != null) {
            EntityType.m_20620_((Level)world, (Player)player, (Entity)pictureFrameEntity, (CompoundTag)nbtCompound);
        }
        pictureFrameEntity.setItemStack(itemStack.m_255036_(1));
        if (!world.f_46443_) {
            pictureFrameEntity.onPlace();
            world.m_220400_((Entity)player, GameEvent.f_157810_, pictureFrameEntity.m_20182_());
            world.m_7967_((Entity)pictureFrameEntity);
        }
        itemStack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public static ItemStack create(String creator, UUID uuid) {
        ItemStack stack = new ItemStack((ItemLike)Camerapture.PICTURE, 1);
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("creator", creator);
        nbt.m_128362_("uuid", uuid);
        nbt.m_128356_("timestamp", System.currentTimeMillis());
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        PictureItem.getTooltip(tooltip::add, stack);
    }

    public static void getTooltip(Consumer<Component> textConsumer, ItemStack stack) {
        PictureData data = PictureItem.getPictureData(stack);
        if (data == null) {
            return;
        }
        textConsumer.accept((Component)Component.m_237110_((String)"item.camerapture.picture.creator_tooltip", (Object[])new Object[]{Component.m_237113_((String)data.creator).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
        String timestamp = SDF.format(new Date(data.timestamp));
        textConsumer.accept((Component)Component.m_237110_((String)"item.camerapture.picture.timestamp_tooltip", (Object[])new Object[]{Component.m_237113_((String)timestamp).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @Nullable
    public static PictureData getPictureData(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("uuid")) {
            return new PictureData(nbt.m_128342_("uuid"), nbt.m_128461_("creator"), nbt.m_128454_("timestamp"));
        }
        return null;
    }

    public record PictureData(UUID id, String creator, long timestamp) {
    }
}

