/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.item;

import me.chrr.camerapture.Camerapture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CameraItem
extends Item {
    public static final ResourceLocation ID = Camerapture.id("camera");
    public static final ResourceKey<Item> KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)ID);
    public static boolean allowUploading = false;

    public CameraItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        boolean active = CameraItem.isActive(stack);
        if (active || !player.m_6144_()) {
            CameraItem.setActive(stack, !active);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!allowUploading && player.m_6144_()) {
            player.m_5661_((Component)Component.m_237115_((String)"text.camerapture.uploading_disabled").m_130940_(ChatFormatting.RED), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!selected) {
            CameraItem.setActive(stack, false);
        }
    }

    public static void setActive(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_("active", active);
    }

    public static boolean isActive(ItemStack stack) {
        return stack.m_41784_().m_128471_("active");
    }

    public static int getPaperInInventory(Player player) {
        return player.m_150109_().m_18947_(Items.f_42516_);
    }

    public static boolean canTakePicture(Player player) {
        return player.m_7500_() || CameraItem.getPaperInInventory(player) > 0;
    }

    @Nullable
    public static HeldCamera find(Player player, boolean shouldBeActive) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (shouldBeActive && !CameraItem.isActive(stack)) continue;
            return new HeldCamera(stack, hand);
        }
        return null;
    }

    public record HeldCamera(ItemStack stack, InteractionHand hand) {
    }
}

