/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.item;

import java.util.ArrayList;
import java.util.List;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.AlbumScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;

public class AlbumItem
extends Item {
    public static final ResourceLocation ID = Camerapture.id("album");
    public static final ResourceKey<Item> KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)ID);
    public static int PAGES = 3;
    public static int ITEMS_PER_PAGE = 12;
    public static int SLOTS = PAGES * ITEMS_PER_PAGE;

    public AlbumItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos = context.m_8083_());
        if (state.m_60713_(Blocks.f_50624_)) {
            return LecternBlock.m_269125_((Entity)context.m_43723_(), (Level)world, (BlockPos)pos, (BlockState)state, (ItemStack)context.m_43722_()) ? InteractionResult.m_19078_((boolean)world.f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && player.m_6144_()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> new AlbumScreenHandler(syncId, playerInventory, (Container)new AlbumInventory(hand, stack)), stack.m_41786_()));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static List<ItemStack> getPictures(ItemStack album) {
        CompoundTag nbt = album.m_41783_();
        if (nbt == null || !nbt.m_128441_("Items")) {
            return List.of();
        }
        ListTag items = nbt.m_128437_("Items", 10);
        ArrayList<ItemStack> pictures = new ArrayList<ItemStack>();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)items.m_128728_(i));
            if (itemStack.m_41619_() || !itemStack.m_150930_(Camerapture.PICTURE)) continue;
            pictures.add(itemStack);
        }
        return pictures;
    }

    public static class AlbumInventory
    extends SimpleContainer {
        private final InteractionHand hand;

        private AlbumInventory(InteractionHand hand, ItemStack stack) {
            super(SLOTS);
            this.hand = hand;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                ContainerHelper.m_18980_((CompoundTag)nbt, this.getHeldStacks());
            }
        }

        public boolean m_6542_(Player player) {
            return this.getAlbumStack(player).m_150930_(Camerapture.ALBUM);
        }

        public void m_5785_(Player player) {
            ContainerHelper.m_18973_((CompoundTag)this.getAlbumStack(player).m_41784_(), this.getHeldStacks());
            super.m_5785_(player);
        }

        public int m_6893_() {
            return 1;
        }

        private ItemStack getAlbumStack(Player player) {
            return player.m_21120_(this.hand);
        }

        private NonNullList<ItemStack> getHeldStacks() {
            return this.f_19147_;
        }
    }
}

