/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.InGameScreen;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import me.chrr.camerapture.util.PictureDrawingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class PictureScreen
extends InGameScreen {
    public static final int MAX_BAR_WIDTH = 360;
    public static final int BORDER_THICKNESS = 24;
    private List<ItemStack> pictures;
    private int index = 0;
    private RemotePicture picture;
    private Component pageNumber;
    private Component customName;
    private boolean ctrlHeld = false;

    public PictureScreen(List<ItemStack> pictures) {
        super((Component)Component.m_237115_((String)"item.camerapture.picture"));
        this.pictures = pictures;
        this.forceRefresh();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.isSinglePicture()) {
            int barWidth = Math.min(360, this.f_96543_ - 48);
            int barX = this.f_96543_ / 2 - barWidth / 2;
            int barY = this.f_96544_ - 24 - 20;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_130674_((String)"\u2190"), button -> this.changeIndexBy(-1)).m_252987_(barX, barY, 20, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_130674_((String)"\u2192"), button -> this.changeIndexBy(1)).m_252987_(barX + barWidth - 20, barY, 20, 20).m_253136_());
        }
    }

    @Override
    public void renderScreen(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.isSinglePicture()) {
            int barY = this.f_96544_ - 24 - 10;
            int pageNumberX = this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.pageNumber) / 2;
            if (this.customName != null) {
                int nameX = this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.customName) / 2;
                Objects.requireNonNull(this.f_96547_);
                context.m_280614_(this.f_96547_, this.customName, nameX, barY - 1 - 9, 0xFFFFFF, false);
                context.m_280614_(this.f_96547_, this.pageNumber, pageNumberX, barY + 1, 0xFFFFFF, false);
            } else {
                Objects.requireNonNull(this.f_96547_);
                context.m_280614_(this.f_96547_, this.pageNumber, pageNumberX, barY - 9 / 2, 0xFFFFFF, false);
            }
        }
        if (this.picture == null) {
            return;
        }
        if (this.ctrlHeld) {
            MutableComponent text = Component.m_237115_((String)"text.camerapture.save_as").m_130940_(ChatFormatting.GRAY);
            int tw = this.f_96547_.m_92852_((FormattedText)text);
            int n = this.f_96543_ / 2 - tw / 2;
            Objects.requireNonNull(this.f_96547_);
            context.m_280614_(this.f_96547_, (Component)text, n, 24 - 9 - 2, 0xFFFFFF, false);
        }
        int bottomOffset = this.isSinglePicture() ? 0 : 24;
        PictureDrawingUtil.drawPicture(context, this.f_96547_, this.picture, 24, 24, this.f_96543_ - 48, this.f_96544_ - 48 - bottomOffset);
    }

    @Nullable
    public NativeImage getNativeImage() {
        if (this.f_96541_ == null || this.picture == null || this.picture.getStatus() != RemotePicture.Status.SUCCESS) {
            return null;
        }
        AbstractTexture texture = this.f_96541_.m_91097_().m_118506_(this.picture.getTextureIdentifier());
        if (!(texture instanceof DynamicTexture)) {
            return null;
        }
        DynamicTexture backedTexture = (DynamicTexture)texture;
        return backedTexture.m_117991_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.ctrlHeld = true;
        } else if (keyCode == 83 && (modifiers & 2) != 0) {
            NativeImage image = this.getNativeImage();
            if (image != null) {
                this.saveAs(image);
                return true;
            }
        } else {
            if (keyCode == 263) {
                this.changeIndexBy(-1);
                return true;
            }
            if (keyCode == 262) {
                this.changeIndexBy(1);
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.ctrlHeld = false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double verticalAmount) {
        this.changeIndexBy((int)(-verticalAmount));
        return true;
    }

    public void changeIndexBy(int delta) {
        if (!this.pictures.isEmpty()) {
            this.index = Math.floorMod(this.index + delta, this.pictures.size());
            this.forceRefresh();
        }
    }

    public void setPictures(List<ItemStack> pictures) {
        this.pictures = pictures;
        this.index = 0;
        this.m_232761_();
        this.forceRefresh();
    }

    private void forceRefresh() {
        this.pageNumber = Component.m_237113_((String)(this.index + 1 + " / " + this.pictures.size())).m_130940_(ChatFormatting.GRAY);
        if (this.index >= this.pictures.size()) {
            this.picture = null;
            this.customName = null;
            return;
        }
        ItemStack stack = this.pictures.get(this.index);
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        if (pictureData == null) {
            return;
        }
        this.picture = ClientPictureStore.getInstance().ensureRemotePicture(pictureData.id());
        this.customName = stack.m_41788_() ? stack.m_41786_() : null;
    }

    private boolean isSinglePicture() {
        return this.pictures.size() == 1;
    }

    private void saveAs(NativeImage image) {
        new Thread(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filter = stack.mallocPointer(1);
                filter.put(stack.UTF8((CharSequence)"png"));
                filter.flip();
                String path = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save Picture", (CharSequence)"picture.png", (PointerBuffer)filter, (CharSequence)"*.png");
                if (path == null) {
                    return;
                }
                try {
                    image.m_85066_(Path.of(path, new String[0]));
                }
                catch (IOException e) {
                    Camerapture.LOGGER.error("failed to save picture to disk", (Throwable)e);
                }
            }
        }, "Save prompter").start();
    }
}

