/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import java.util.Objects;
import java.util.function.Consumer;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.PictureFrameScreenHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class PictureFrameScreen
extends AbstractContainerScreen<PictureFrameScreenHandler>
implements ContainerListener {
    private static final ResourceLocation TEXTURE = Camerapture.id("textures/gui/edit_picture_frame.png");
    private int frameWidth = 0;
    private int frameHeight = 0;
    private boolean glowing = false;
    private boolean fixed = false;
    private Button upButton;
    private Button leftButton;
    private Button rightButton;
    private Button downButton;
    private SmallCheckboxWidget glowingCheckbox;
    private SmallCheckboxWidget fixedCheckbox;

    public PictureFrameScreen(PictureFrameScreenHandler screenHandler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)screenHandler, inventory, title);
        screenHandler.m_38893_(this);
        this.f_97726_ = 158;
        this.f_97727_ = 52;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.upButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> {
            this.sendButtonPressPacket(PictureFrameScreen.m_96638_() ? 0 : 1);
            this.frameHeight += PictureFrameScreen.m_96638_() ? -1 : 1;
        }).m_252987_(this.f_96543_ / 2 - this.f_97726_ / 2, this.f_96544_ / 2 - this.f_97727_ / 2 - 20 - 4, this.f_97726_, 20).m_253136_());
        this.rightButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> {
            this.sendButtonPressPacket(PictureFrameScreen.m_96638_() ? 2 : 3);
            this.frameWidth += PictureFrameScreen.m_96638_() ? -1 : 1;
        }).m_252987_(this.f_96543_ / 2 + this.f_97726_ / 2 + 4, this.f_96544_ / 2 - this.f_97727_ / 2, 20, this.f_97727_).m_253136_());
        this.downButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> {
            this.sendButtonPressPacket(PictureFrameScreen.m_96638_() ? 4 : 5);
            this.frameHeight += PictureFrameScreen.m_96638_() ? -1 : 1;
        }).m_252987_(this.f_96543_ / 2 - this.f_97726_ / 2, this.f_96544_ / 2 + this.f_97727_ / 2 + 4, this.f_97726_, 20).m_253136_());
        this.leftButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> {
            this.sendButtonPressPacket(PictureFrameScreen.m_96638_() ? 6 : 7);
            this.frameWidth += PictureFrameScreen.m_96638_() ? -1 : 1;
        }).m_252987_(this.f_96543_ / 2 - this.f_97726_ / 2 - 20 - 4, this.f_96544_ / 2 - this.f_97727_ / 2, 20, this.f_97727_).m_253136_());
        this.glowingCheckbox = (SmallCheckboxWidget)this.m_142416_((GuiEventListener)new SmallCheckboxWidget((Component)Component.m_237115_((String)"text.camerapture.edit_picture_frame.glowing"), glowing -> {
            this.sendButtonPressPacket(8);
            this.glowing = glowing;
        }, this.f_96543_ / 2 - this.f_97726_ / 2 + 7, this.f_96544_ / 2 - this.f_97727_ / 2 + 34, false, this.glowing));
        this.fixedCheckbox = (SmallCheckboxWidget)this.m_142416_((GuiEventListener)new SmallCheckboxWidget((Component)Component.m_237115_((String)"text.camerapture.edit_picture_frame.fixed"), fixed -> {
            this.sendButtonPressPacket(9);
            this.fixed = fixed;
        }, this.f_96543_ / 2 + this.f_97726_ / 2 - 7 - 11, this.f_96544_ / 2 - this.f_97727_ / 2 + 34, true, this.fixed));
        this.updateButtons();
    }

    private void sendButtonPressPacket(int id) {
        if (this.f_96541_ == null || this.f_96541_.f_91072_ == null) {
            return;
        }
        this.f_96541_.f_91072_.m_105208_(((PictureFrameScreenHandler)this.f_97732_).f_38840_, id);
    }

    public void m_7934_(AbstractContainerMenu handler, int slotId, ItemStack stack) {
    }

    public void m_142153_(AbstractContainerMenu handler, int property, int value) {
        switch (property) {
            case 0: {
                this.frameWidth = value;
                break;
            }
            case 1: {
                this.frameHeight = value;
                break;
            }
            case 2: {
                this.glowing = value == 1;
                break;
            }
            case 3: {
                this.fixed = value == 1;
            }
        }
        this.updateButtons();
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
        context.m_280653_(this.f_96547_, (Component)Component.m_237110_((String)"text.camerapture.edit_picture_frame.size", (Object[])new Object[]{this.frameWidth, this.frameHeight}), this.f_97726_ / 2, 7, 0xFFFFFF);
        MutableComponent mutableComponent = Component.m_237115_((String)"text.camerapture.edit_picture_frame.shrink_hint");
        int n = this.f_97726_ / 2;
        Objects.requireNonNull(this.f_96547_);
        context.m_280653_(this.f_96547_, (Component)mutableComponent, n, 7 + 9 + 2, 0xA0A0A0);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    private void updateButtons() {
        if (PictureFrameScreen.m_96638_()) {
            this.upButton.m_93666_(Component.m_130674_((String)"\u2193"));
            this.leftButton.m_93666_(Component.m_130674_((String)"\u2192"));
            this.rightButton.m_93666_(Component.m_130674_((String)"\u2190"));
            this.downButton.m_93666_(Component.m_130674_((String)"\u2191"));
            this.upButton.f_93623_ = this.frameHeight > 1;
            this.leftButton.f_93623_ = this.frameWidth > 1;
            this.rightButton.f_93623_ = this.frameWidth > 1;
            this.downButton.f_93623_ = this.frameHeight > 1;
        } else {
            this.upButton.m_93666_(Component.m_130674_((String)"\u2191"));
            this.leftButton.m_93666_(Component.m_130674_((String)"\u2190"));
            this.rightButton.m_93666_(Component.m_130674_((String)"\u2192"));
            this.downButton.m_93666_(Component.m_130674_((String)"\u2193"));
            this.upButton.f_93623_ = this.frameHeight < 16;
            this.leftButton.f_93623_ = this.frameWidth < 16;
            this.rightButton.f_93623_ = this.frameWidth < 16;
            this.downButton.f_93623_ = this.frameHeight < 16;
        }
        this.glowingCheckbox.checked = this.glowing;
        this.fixedCheckbox.checked = this.fixed;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.updateButtons();
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.updateButtons();
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private static class SmallCheckboxWidget
    extends AbstractButton {
        private final boolean leftText;
        private boolean checked;
        private final Consumer<Boolean> onChange;

        public SmallCheckboxWidget(Component text, Consumer<Boolean> onChange, int x, int y, boolean leftText, boolean checked) {
            super(x, y, 11, 11, text);
            this.onChange = onChange;
            this.leftText = leftText;
            this.checked = checked;
        }

        public void m_5691_() {
            this.checked = !this.checked;
            this.onChange.accept(this.checked);
        }

        protected void m_168797_(NarrationElementOutput builder) {
            builder.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
            if (this.f_93623_) {
                if (this.m_93696_()) {
                    builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.focused"));
                } else {
                    builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.hovered"));
                }
            }
        }

        protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            Minecraft minecraftClient = Minecraft.m_91087_();
            Font textRenderer = minecraftClient.f_91062_;
            int textX = this.m_252754_() + (this.leftText ? -4 - textRenderer.m_92852_((FormattedText)this.m_6035_()) : 15);
            context.m_280430_(textRenderer, this.m_6035_(), textX, this.m_252907_() + 2, 0xE0E0E0);
            context.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_198029_() ? 11.0f : 0.0f, 52.0f, 11, 11, 256, 256);
            if (this.checked) {
                context.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 22.0f, 52.0f, 11, 11, 256, 256);
            }
        }
    }
}

