/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.AlbumScreenHandler;
import me.chrr.camerapture.gui.PictureSlot;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import me.chrr.camerapture.util.PictureDrawingUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class AlbumScreen
extends AbstractContainerScreen<AlbumScreenHandler> {
    private static final ResourceLocation TEXTURE = Camerapture.id("textures/gui/edit_album.png");
    private int activePage = 0;
    private Component pageText = Component.m_237119_();
    private PageButton previousButton;
    private PageButton nextButton;

    public AlbumScreen(AlbumScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 280;
        this.f_97727_ = 237;
        this.f_97730_ = 60;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97728_ = 19;
        this.f_97729_ = 15;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.previousButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.f_97735_ + 22, this.f_97736_ + 121, false, button -> this.changePage(-1), true));
        this.nextButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.f_97735_ + 234, this.f_97736_ + 121, true, button -> this.changePage(1), true));
        this.updatePage();
    }

    private void changePage(int delta) {
        this.activePage = Math.min(Math.max(this.activePage + delta, 0), AlbumItem.PAGES);
        this.updatePage();
    }

    private void updatePage() {
        for (int i = 0; i < AlbumItem.SLOTS; ++i) {
            int page = i / AlbumItem.ITEMS_PER_PAGE;
            ((PictureSlot)((Object)((AlbumScreenHandler)this.f_97732_).f_38839_.get(i))).setEnabled(page == this.activePage);
        }
        this.pageText = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{this.activePage + 1, AlbumItem.PAGES});
        this.previousButton.f_93624_ = this.activePage != 0;
        this.nextButton.f_93624_ = this.activePage != AlbumItem.PAGES - 1;
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 512);
    }

    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
        context.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0, false);
        context.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        int textWidth = this.f_96547_.m_92852_((FormattedText)this.pageText);
        int pageX = this.f_97726_ - this.f_97728_ - textWidth;
        context.m_280614_(this.f_96547_, this.pageText, pageX, this.f_97729_, 0, false);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280072_(context, mouseX, mouseY);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        int xOffset = mouseY - (double)top > 148.0 ? 52 : 0;
        return mouseX < (double)(left + xOffset) || mouseY < (double)top || mouseX >= (double)(left + this.f_97726_ - xOffset) || mouseY >= (double)(top + this.f_97727_);
    }

    protected void m_280092_(GuiGraphics context, Slot slot) {
        if (!(slot instanceof PictureSlot)) {
            super.m_280092_(context, slot);
            return;
        }
        PictureSlot pictureSlot = (PictureSlot)slot;
        RenderSystem.enableBlend();
        if (pictureSlot.m_6657_()) {
            PictureItem.PictureData pictureData = PictureItem.getPictureData(slot.m_7993_());
            if (pictureData != null) {
                RemotePicture picture = ClientPictureStore.getInstance().ensureRemotePicture(pictureData.id());
                PictureDrawingUtil.drawPicture(context, this.f_96547_, picture, slot.f_40220_, slot.f_40221_, pictureSlot.getWidth(), pictureSlot.getHeight());
            }
        } else {
            context.m_280163_(TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, 280.0f, 0.0f, pictureSlot.getWidth() + 2, pictureSlot.getHeight() + 2, 512, 512);
        }
        RenderSystem.disableBlend();
    }
}

