/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.forge;

import com.luciad.imageio.webp.WebPImageReaderSpi;
import com.luciad.imageio.webp.WebPImageWriterSpi;
import java.util.List;
import javax.imageio.spi.IIORegistry;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.CameraptureClient;
import me.chrr.camerapture.compat.ClothConfigScreenFactory;
import me.chrr.camerapture.gui.AlbumLecternScreen;
import me.chrr.camerapture.gui.AlbumScreen;
import me.chrr.camerapture.gui.CameraViewFinder;
import me.chrr.camerapture.gui.PictureFrameScreen;
import me.chrr.camerapture.gui.PictureScreen;
import me.chrr.camerapture.gui.UploadScreen;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.PictureTaker;
import me.chrr.camerapture.render.PictureFrameEntityRenderer;
import me.chrr.camerapture.render.PictureItemRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class CameraptureClientForge {
    public CameraptureClientForge(IEventBus modBus) {
        modBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        if (ModList.get().isLoaded("cloth_config")) {
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> ClothConfigScreenFactory.create(parent)));
        }
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        CameraptureClient.init();
        CameraptureClient.registerPacketHandlers();
        IIORegistry.getDefaultInstance().registerServiceProvider(new WebPImageReaderSpi());
        IIORegistry.getDefaultInstance().registerServiceProvider(new WebPImageWriterSpi());
        event.enqueueWork(() -> {
            ItemProperties.register((Item)Camerapture.PICTURE, (ResourceLocation)Camerapture.id("should_render_picture"), (stack, world, entity, seed) -> PictureItemRenderer.canRender(stack) ? 1.0f : 0.0f);
            MenuScreens.m_96206_(Camerapture.PICTURE_FRAME_SCREEN_HANDLER, PictureFrameScreen::new);
            MenuScreens.m_96206_(Camerapture.ALBUM_SCREEN_HANDLER, AlbumScreen::new);
            MenuScreens.m_96206_(Camerapture.ALBUM_LECTERN_SCREEN_HANDLER, AlbumLecternScreen::new);
        });
    }

    @SubscribeEvent
    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(Camerapture.PICTURE_FRAME, PictureFrameEntityRenderer::new);
    }

    private static class ClientEvents {
        private ClientEvents() {
        }

        @SubscribeEvent
        public void onAttack(InputEvent.InteractionKeyMappingTriggered event) {
            if (!event.isAttack()) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            CameraItem.HeldCamera camera = CameraItem.find((Player)player, true);
            if (camera == null) {
                return;
            }
            if (CameraItem.canTakePicture((Player)player)) {
                PictureTaker.getInstance().takePicture();
            }
            event.setSwingHand(false);
            event.setCanceled(true);
        }

        @SubscribeEvent
        public InteractionResult onUseItem(PlayerInteractEvent.RightClickItem event) {
            if (event.getSide() != LogicalSide.CLIENT) {
                return InteractionResult.PASS;
            }
            ItemStack stack = event.getItemStack();
            Player player = event.getEntity();
            Minecraft client = Minecraft.m_91087_();
            if (client.f_91074_ != player) {
                return InteractionResult.PASS;
            }
            if (stack.m_150930_(Camerapture.PICTURE)) {
                if (PictureItem.getPictureData(stack) != null) {
                    client.m_201446_(() -> client.m_91152_((Screen)new PictureScreen(List.of(stack))));
                    return InteractionResult.SUCCESS;
                }
            } else if (stack.m_150930_(Camerapture.ALBUM) && !player.m_6144_()) {
                List<ItemStack> pictures = AlbumItem.getPictures(stack);
                if (!pictures.isEmpty()) {
                    client.m_201446_(() -> client.m_91152_((Screen)new PictureScreen(pictures)));
                    return InteractionResult.SUCCESS;
                }
            } else if (CameraItem.allowUploading && player.m_6144_() && stack.m_150930_(Camerapture.CAMERA) && !CameraItem.isActive(stack) && !player.m_36335_().m_41519_(Camerapture.CAMERA)) {
                client.m_201446_(() -> client.m_91152_((Screen)new UploadScreen()));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        @SubscribeEvent
        public void onRenderTickEnd(TickEvent.RenderTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                PictureTaker.getInstance().renderTickEnd();
            }
        }

        @SubscribeEvent
        public void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            ClientPictureStore.getInstance().clear();
            PictureTaker.getInstance().configureFromConfig();
            CameraItem.allowUploading = Camerapture.CONFIG_MANAGER.getConfig().server.allowUploading;
        }

        @SubscribeEvent
        public void onRenderHand(RenderHandEvent event) {
            CameraItem.HeldCamera camera = CameraItem.find((Player)Minecraft.m_91087_().f_91074_, true);
            if (camera != null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onRenderGui(RenderGuiEvent.Pre event) {
            CameraItem.HeldCamera camera = CameraItem.find((Player)Minecraft.m_91087_().f_91074_, true);
            if (camera == null) {
                PictureTaker.getInstance().zoomLevel = 1.0f;
                return;
            }
            event.setCanceled(true);
            if (!Minecraft.m_91087_().f_91066_.f_92062_) {
                CameraViewFinder.drawCameraViewFinder(event.getGuiGraphics(), Minecraft.m_91087_().f_91062_);
            }
        }

        @SubscribeEvent
        public void onScroll(InputEvent.MouseScrollingEvent event) {
            if (CameraItem.find((Player)Minecraft.m_91087_().f_91074_, true) != null) {
                PictureTaker.getInstance().zoom((float)(event.getScrollDelta() / 4.0));
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onFovModifier(ComputeFovModifierEvent event) {
            if (CameraItem.find((Player)Minecraft.m_91087_().f_91074_, true) != null) {
                event.setNewFovModifier(PictureTaker.getInstance().getFovModifier());
            }
        }
    }
}

