/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.entity;

import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.entity.ResizableDecorationEntity;
import me.chrr.camerapture.gui.PictureFrameScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PictureFrameEntity
extends ResizableDecorationEntity
implements MenuProvider {
    public static final ResourceLocation ID = Camerapture.id("picture_frame");
    public static final ResourceKey<EntityType<?>> KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256939_, (ResourceLocation)ID);
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(PictureFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> GLOWING = SynchedEntityData.m_135353_(PictureFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FIXED = SynchedEntityData.m_135353_(PictureFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ROTATION = SynchedEntityData.m_135353_(PictureFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PictureFrameEntity(EntityType<? extends PictureFrameEntity> entityType, Level world) {
        super(entityType, world);
    }

    public PictureFrameEntity(Level world, BlockPos pos, Direction facing) {
        super(Camerapture.PICTURE_FRAME, world);
        this.setAttachmentPos(pos);
        this.setFacing(facing);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(GLOWING, (Object)false);
        this.m_20088_().m_135372_(FIXED, (Object)false);
        this.m_20088_().m_135372_(ROTATION, (Object)0);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        boolean canRotate = Camerapture.CONFIG_MANAGER.getConfig().server.canRotatePictures;
        if (player.m_6144_()) {
            player.m_5893_((MenuProvider)this);
            return InteractionResult.SUCCESS;
        }
        if (canRotate && !this.isFixed()) {
            if (!player.m_9236_().f_46443_) {
                this.setRotation(this.getRotation() + 1);
                this.m_5496_(SoundEvents.f_12017_, 1.0f, 1.0f);
                this.m_146852_(GameEvent.f_157792_, (Entity)player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onBreak(@Nullable Entity entity) {
        this.m_5496_(SoundEvents.f_12014_, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157792_, entity);
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.m_41619_()) {
            itemStack.m_41636_(null);
            this.m_19983_(itemStack);
        }
    }

    @Override
    public void onPlace() {
        this.m_5496_(SoundEvents.f_12015_, 1.0f, 1.0f);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM_STACK);
    }

    public void setItemStack(ItemStack itemStack) {
        this.m_20088_().m_135381_(ITEM_STACK, (Object)itemStack);
    }

    public boolean isPictureGlowing() {
        return (Boolean)this.m_20088_().m_135370_(GLOWING);
    }

    public void setPictureGlowing(boolean glowing) {
        this.m_20088_().m_135381_(GLOWING, (Object)glowing);
    }

    public boolean isFixed() {
        return (Boolean)this.m_20088_().m_135370_(FIXED);
    }

    public void setFixed(boolean fixed) {
        this.m_20088_().m_135381_(FIXED, (Object)fixed);
        this.resetObstructionCheckCounter();
    }

    public int getRotation() {
        return (Integer)this.m_20088_().m_135370_(ROTATION);
    }

    public void setRotation(int rotation) {
        this.m_20088_().m_135381_(ROTATION, (Object)(rotation % 4));
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> data) {
        ItemStack itemStack;
        super.m_7350_(data);
        if (data.equals(ITEM_STACK) && !(itemStack = this.getItemStack()).m_41619_()) {
            itemStack.m_41636_((Entity)this);
        }
    }

    public boolean m_6783_(double distance) {
        double d = 16.0;
        return distance < (d *= 4.0 * PictureFrameEntity.m_20150_()) * d;
    }

    @Override
    public void m_6478_(MoverType movementType, Vec3 movement) {
        if (!this.isFixed()) {
            super.m_6478_(movementType, movement);
        }
    }

    @Override
    public void m_5997_(double deltaX, double deltaY, double deltaZ) {
        if (!this.isFixed()) {
            super.m_5997_(deltaX, deltaY, deltaZ);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isFixed() && !source.m_269533_(DamageTypeTags.f_268738_) && !source.m_19390_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean canStayAttached() {
        return this.isFixed() || super.canStayAttached();
    }

    public void resize(ResizeDirection direction, boolean shrink) {
        boolean success;
        switch (direction.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: 
            case 1: {
                boolean bl = this.tryAddHeight(shrink ? -1 : 1);
                break;
            }
            case 2: 
            case 3: {
                boolean bl = success = this.tryAddWidth(shrink ? -1 : 1);
            }
        }
        if (success) {
            int i = shrink ? 1 : -1;
            switch (direction.ordinal()) {
                case 1: {
                    this.setAttachmentPos(this.getAttachmentPos().m_5484_(Direction.UP, i));
                    break;
                }
                case 2: {
                    this.setAttachmentPos(this.getAttachmentPos().m_5484_(this.getFacing().m_122428_(), i));
                }
            }
        }
        this.resetObstructionCheckCounter();
    }

    private boolean tryAddWidth(int n) {
        int width = this.getFrameWidth();
        if (width >= 1 - n && width <= 16 - n) {
            this.setFrameWidth(width + n);
            return true;
        }
        return false;
    }

    private boolean tryAddHeight(int n) {
        int height = this.getFrameHeight();
        if (height >= 1 - n && height <= 16 - n) {
            this.setFrameHeight(height + n);
            return true;
        }
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.getFacing().m_122411_(), this.m_20183_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.setFacing(Direction.m_122376_((int)packet.m_131509_()));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.m_41619_()) {
            nbt.m_128365_("Item", (Tag)itemStack.m_41739_(new CompoundTag()));
        }
        nbt.m_128379_("PictureGlowing", this.isPictureGlowing());
        nbt.m_128379_("Fixed", this.isFixed());
        nbt.m_128405_("PictureRotation", this.getRotation());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        CompoundTag nbtCompound = nbt.m_128469_("Item");
        if (nbtCompound != null && !nbtCompound.m_128456_()) {
            this.setItemStack(ItemStack.m_41712_((CompoundTag)nbtCompound));
        }
        this.setPictureGlowing(nbt.m_128471_("PictureGlowing"));
        this.setFixed(nbt.m_128471_("Fixed"));
        this.setRotation(nbt.m_128451_("PictureRotation"));
    }

    public ItemStack m_142340_() {
        return this.getItemStack().m_41777_();
    }

    public boolean m_8077_() {
        return this.getItemStack().m_41788_();
    }

    @Nullable
    public Component m_7770_() {
        return this.m_8077_() ? this.getItemStack().m_41786_() : null;
    }

    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new PictureFrameScreenHandler(syncId, this, new ContainerData(){

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> PictureFrameEntity.this.getFrameWidth();
                    case 1 -> PictureFrameEntity.this.getFrameHeight();
                    case 2 -> {
                        if (PictureFrameEntity.this.isPictureGlowing()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 3 -> {
                        if (PictureFrameEntity.this.isFixed()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int id, int value) {
            }

            public int m_6499_() {
                return 4;
            }
        });
    }

    public static enum ResizeDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

