/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.multiblock;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Rotation;
import com.brandon3055.brandonscore.multiblock.MultiBlockDefinition;
import com.brandon3055.brandonscore.multiblock.MultiBlockPart;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class MultiBlockManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger(MultiBlockManager.class);
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, MultiBlockDefinition> LOCAL_DEFINITIONS = new HashMap<ResourceLocation, MultiBlockDefinition>();
    private static final Map<ResourceLocation, MultiBlockDefinition> SERVER_DEFINITIONS = new HashMap<ResourceLocation, MultiBlockDefinition>();

    public MultiBlockManager() {
        super(GSON, "multiblocks");
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(MultiBlockManager::addReloadListeners);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(MultiBlockManager::onDisconnectFromServer));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> MinecraftForge.EVENT_BUS.addListener(MultiBlockManager::onSendDataToClient));
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new MultiBlockManager());
    }

    private static void onSendDataToClient(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            BCoreNetwork.sendMultiBlockDefinitions(event.getPlayer(), LOCAL_DEFINITIONS);
        } else {
            event.getPlayerList().m_11314_().forEach(player -> BCoreNetwork.sendMultiBlockDefinitions(player, LOCAL_DEFINITIONS));
        }
    }

    public static void receiveDefinitionsFromServer(PacketCustom packet) {
        int count = packet.readVarInt();
        for (int i = 0; i < count; ++i) {
            ResourceLocation id = packet.readResourceLocation();
            String jsonString = packet.readString();
            SERVER_DEFINITIONS.put(id, new MultiBlockDefinition(id, JsonParser.parseString((String)jsonString)));
        }
    }

    private static void onDisconnectFromServer(ClientPlayerNetworkEvent.LoggingOut event) {
        SERVER_DEFINITIONS.clear();
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller filter) {
        LOCAL_DEFINITIONS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement json = entry.getValue();
            try {
                LOCAL_DEFINITIONS.put(id, new MultiBlockDefinition(id, json));
            }
            catch (Throwable e) {
                LOGGER.error("An exception occurred while loading Multi-Block Definition from json.");
                e.printStackTrace();
            }
        }
    }

    public static Map<ResourceLocation, MultiBlockDefinition> getDefinitions() {
        if (SERVER_DEFINITIONS.isEmpty()) {
            return ImmutableMap.copyOf(LOCAL_DEFINITIONS);
        }
        return ImmutableMap.copyOf(SERVER_DEFINITIONS);
    }

    public static ImmutableList<ResourceLocation> getRegisteredIds() {
        return ImmutableList.copyOf(MultiBlockManager.getDefinitions().keySet());
    }

    @Nullable
    public static MultiBlockDefinition getDefinition(ResourceLocation id) {
        return MultiBlockManager.getDefinitions().getOrDefault(id, null);
    }

    public static int placeCommand(ServerLevel level, BlockPos placePos, ResourceLocation id, Vec3 rotation) {
        MultiBlockDefinition definition = MultiBlockManager.getDefinition(id);
        if (definition != null) {
            for (Map.Entry<BlockPos, MultiBlockPart> entry : definition.getBlocks(new Rotation(new Quat(new Quaternionf().rotationXYZ((float)rotation.f_82479_ * ((float)Math.PI / 180), (float)rotation.f_82480_ * ((float)Math.PI / 180), (float)rotation.f_82481_ * ((float)Math.PI / 180))))).entrySet()) {
                BlockPos offset = entry.getKey();
                ArrayList blocks = Lists.newArrayList(entry.getValue().validBlocks());
                if (blocks.isEmpty()) continue;
                BlockPos pos = placePos.m_121955_((Vec3i)offset);
                level.m_46597_(pos, ((Block)blocks.get(0)).m_49966_());
            }
            return 0;
        }
        return 1;
    }
}

