/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.multiblock;

import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.multiblock.BlockPart;
import com.brandon3055.brandonscore.multiblock.EmptyPart;
import com.brandon3055.brandonscore.multiblock.InvalidPart;
import com.brandon3055.brandonscore.multiblock.MultiBlockPart;
import com.brandon3055.brandonscore.multiblock.TagPart;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class MultiBlockDefinition {
    private final ResourceLocation id;
    private final JsonElement json;
    private BlockPos origin = BlockPos.f_121853_;
    private Map<BlockPos, MultiBlockPart> blockMap = new HashMap<BlockPos, MultiBlockPart>();

    public MultiBlockDefinition(ResourceLocation id, JsonElement json) {
        this.id = id;
        this.json = json;
        this.loadFromJson();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public JsonElement getJson() {
        return this.json;
    }

    public Map<BlockPos, MultiBlockPart> getBlocks() {
        return ImmutableMap.copyOf(this.blockMap);
    }

    public Map<BlockPos, MultiBlockPart> getBlocksAt(BlockPos worldOrigin) {
        HashMap translated = new HashMap();
        this.blockMap.forEach((pos, part) -> translated.put(worldOrigin.m_121955_((Vec3i)pos), part));
        return ImmutableMap.copyOf(translated);
    }

    public Map<BlockPos, MultiBlockPart> getBlocks(Rotation rotation) {
        HashMap transformed = new HashMap();
        Transformation transform = (Transformation)rotation.at(Vector3.CENTER).inverse();
        this.blockMap.forEach((pos, part) -> {
            Vector3 vec = Vector3.fromBlockPosCenter((BlockPos)pos);
            vec.apply(transform);
            transformed.put(vec.pos(), part);
        });
        return ImmutableMap.copyOf(transformed);
    }

    public Map<BlockPos, MultiBlockPart> getBlocksAt(BlockPos worldOrigin, Rotation rotation) {
        HashMap transformed = new HashMap();
        Transformation transform = (Transformation)rotation.at(Vector3.CENTER).inverse();
        this.blockMap.forEach((pos, part) -> {
            Vector3 vec = Vector3.fromBlockPosCenter((BlockPos)pos);
            vec.apply(transform);
            transformed.put(vec.add(worldOrigin).pos(), part);
        });
        return ImmutableMap.copyOf(transformed);
    }

    public List<InvalidPart> test(Level level, BlockPos originPos) {
        ArrayList<InvalidPart> result = new ArrayList<InvalidPart>();
        this.getBlocksAt(originPos).forEach((pos, part) -> {
            if (!part.isMatch(level, (BlockPos)pos)) {
                result.add(new InvalidPart((BlockPos)pos, (MultiBlockPart)part));
            }
        });
        return result;
    }

    public List<InvalidPart> test(Level level, BlockPos originPos, Rotation rotation) {
        ArrayList<InvalidPart> result = new ArrayList<InvalidPart>();
        this.getBlocksAt(originPos, rotation).forEach((pos, part) -> {
            if (!part.isMatch(level, (BlockPos)pos)) {
                result.add(new InvalidPart((BlockPos)pos, (MultiBlockPart)part));
            }
        });
        return result;
    }

    private void loadFromJson() {
        JsonObject obj = this.json.getAsJsonObject();
        if (obj.has("origin")) {
            JsonObject originObj = obj.getAsJsonObject("origin");
            this.origin = new BlockPos(originObj.get("x").getAsInt(), originObj.get("y").getAsInt(), originObj.get("z").getAsInt());
        }
        HashMap<String, MultiBlockPart> keyMap = new HashMap<String, MultiBlockPart>();
        JsonObject keysObj = obj.getAsJsonObject("keys");
        for (Map.Entry entry : keysObj.entrySet()) {
            ResourceLocation resourcelocation;
            String key = (String)entry.getKey();
            if (keyMap.containsKey(key)) {
                throw new IllegalStateException("Duplicate key detected!, " + this.id);
            }
            JsonObject keyVal = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (keyVal.has("tag")) {
                resourcelocation = new ResourceLocation(keyVal.get("tag").getAsString());
                TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)resourcelocation);
                keyMap.put(key, new TagPart((TagKey<Block>)tagkey));
                continue;
            }
            if (keyVal.has("block")) {
                resourcelocation = new ResourceLocation(keyVal.get("block").getAsString());
                if (ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50016_).equals((Object)resourcelocation)) {
                    keyMap.put(key, new EmptyPart());
                    continue;
                }
                keyMap.put(key, new BlockPart(resourcelocation));
                continue;
            }
            throw new IllegalArgumentException("Invalid block key detected!, " + keyVal + ", " + this.id);
        }
        JsonArray structure = obj.getAsJsonArray("structure");
        int layer = 0;
        for (JsonElement layerElement : structure) {
            JsonArray layerArray = layerElement.getAsJsonArray();
            int row = 0;
            for (JsonElement rowElement : layerArray) {
                String rowString = rowElement.getAsString();
                for (int i = 0; i < rowString.length(); ++i) {
                    String key = String.valueOf(rowString.charAt(i));
                    BlockPos pos = new BlockPos(i, layer, row).m_121996_((Vec3i)this.origin);
                    if (this.blockMap.containsKey(pos)) {
                        throw new IllegalStateException("Duplicate Position Detected");
                    }
                    if (key.equals(" ")) continue;
                    if (!keyMap.containsKey(key)) {
                        throw new IllegalArgumentException("Undefined key in multiblock definition: " + this.id + ", Key: " + key);
                    }
                    this.blockMap.put(pos, (MultiBlockPart)keyMap.get(key));
                }
                ++row;
            }
            ++layer;
        }
    }
}

