/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.coremod;

import java.io.IOException;
import javax.script.ScriptException;
import net.minecraftforge.coremod.CoreMod;
import org.jetbrains.annotations.Nullable;

public class CoreModTracker {
    private static ThreadLocal<CoreModTracker> coreModThreadLocal = ThreadLocal.withInitial(CoreModTracker::new);
    private CoreMod tracked;

    public static void setCoreMod(CoreMod coreMod) {
        CoreModTracker.coreModThreadLocal.get().tracked = coreMod;
    }

    public static void clearCoreMod() {
        CoreModTracker.coreModThreadLocal.get().tracked = null;
    }

    public static boolean loadFileByName(String file) throws ScriptException, IOException {
        CoreMod tracked = CoreModTracker.coreModThreadLocal.get().tracked;
        if (tracked != null) {
            return tracked.loadAdditionalFile(file);
        }
        return false;
    }

    @Nullable
    public static Object loadDataByName(String file) throws ScriptException, IOException {
        CoreMod tracked = CoreModTracker.coreModThreadLocal.get().tracked;
        if (tracked != null) {
            return tracked.loadAdditionalData(file);
        }
        return null;
    }

    public static void log(String level, String message, Object[] args) {
        CoreMod tracked = CoreModTracker.coreModThreadLocal.get().tracked;
        if (tracked != null) {
            tracked.logMessage(level, message, args);
        }
    }
}

