/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.impl.SecureJarVerifier;
import java.security.CodeSigner;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

class ManifestVerifier {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("securejarhandler.debugVerifier", "false"));
    private static final Base64.Decoder BASE64D = Base64.getDecoder();
    private final Map<String, MessageDigest> HASHERS = new HashMap<String, MessageDigest>();

    ManifestVerifier() {
    }

    private MessageDigest getHasher(String name) {
        return this.HASHERS.computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> {
            try {
                return MessageDigest.getInstance(k);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void log(String line) {
        System.out.println(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CodeSigner[]> verify(Manifest manifest, Map<String, CodeSigner[]> pending, Map<String, CodeSigner[]> verified, String name, byte[] data) {
        record Expected(MessageDigest hash, byte[] value) {
        }
        Attributes attr;
        if (DEBUG) {
            this.log("[SJH] Verifying: " + name);
        }
        if ((attr = manifest.getAttributes(name)) == null) {
            if (DEBUG) {
                this.log("[SJH]   No Manifest Entry");
            }
            return Optional.empty();
        }
        ArrayList expected = new ArrayList();
        attr.forEach((k, v) -> {
            String key = k.toString();
            if (key.toLowerCase(Locale.ENGLISH).endsWith("-digest")) {
                String algo = key.substring(0, key.length() - 7);
                byte[] hash = BASE64D.decode((String)v);
                expected.add(new Expected(this.getHasher(algo), hash));
            }
        });
        if (expected.isEmpty()) {
            if (DEBUG) {
                this.log("[SJH]   No Manifest Hashes");
            }
            return Optional.empty();
        }
        for (Expected exp : expected) {
            MessageDigest messageDigest = exp.hash();
            synchronized (messageDigest) {
                exp.hash().reset();
                byte[] actual = exp.hash().digest(data);
                if (DEBUG) {
                    this.log("[SJH]   " + exp.hash().getAlgorithm() + " Expected: " + SecureJarVerifier.toHexString(exp.value()));
                    this.log("[SJH]   " + exp.hash().getAlgorithm() + " Actual:   " + SecureJarVerifier.toHexString(actual));
                }
                if (!Arrays.equals(exp.value(), actual)) {
                    if (DEBUG) {
                        this.log("[SJH]   Failed: Invalid hashes");
                    }
                    return null;
                }
            }
        }
        CodeSigner[] signers = pending.remove(name);
        if (signers != null) {
            verified.put(name, signers);
        }
        return Optional.ofNullable(signers);
    }
}

